/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.spring.config;

import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.FileUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.PropertiesUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.exception.FitException;
import com.huawei.fitframework.runtime.support.DefaultFitFrameworkVersion;
import com.huawei.fitframework.spring.config.CommandBuilder;
import com.huawei.fitframework.spring.config.FitConfiguration;
import com.huawei.fitframework.spring.config.Log;
import com.huawei.fitframework.spring.config.Matata;
import com.huawei.fitframework.spring.config.Server;
import com.huawei.fitframework.spring.config.Worker;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class Fit
implements CommandBuilder {
    private static final Logger logger = LoggerFactory.getLogger(Fit.class);
    private static final String FIT_HOME = "FIT_HOME";
    private static final String DIRECTORY_SEPARATOR = ",";
    private static final String FITFRAMEWORK = "fitframework";
    private static final String EXTENSIONS = "extensions";
    private static final String PLUGINS = "plugins";
    private static final String CONF = "conf";
    private static final String BIN = "bin";
    private static final String FRAMEWORK_DIRECTORY = "framework.directory";
    private static final String PLUGIN_DIRECTORIES = "plugin.directories";
    private static final String SHARED_DIRECTORIES = "shared.directories";
    private static final String EXTENSION_DIRECTORIES = "extension.directories";
    private static final String FIT_CONTAINER_TYPE = "fit.container.type";
    private static final String FIT_HOME_DIRECTORY = "fit.homeDirectory";
    private static final String FIT_PLUGIN_DIRECTORIES = "fit.pluginDirectories";
    private static final String FIT_SHARED_DIRECTORIES = "fit.sharedDirectories";
    private static final String SPRING = "spring";
    private static final String EXTENSIONS_PROPERTIES_FILE_NAME = "extensions.properties";
    private static final String PLUGIN_PROPERTIES_FILE_NAME = "plugin.properties";
    private static final String PLUGIN_BUILT_IN = "plugin.built-in";
    private static final String ARTIFACT_ID = "fit-launcher";
    private static final String GROUP_ID = "com.huawei.fitframework";
    private static final String CONFIG_PROPERTIES = "config.properties";
    private static final String DEFAULT_HOME_DIRECTORY_PARTS_KEY = "defaultHomeDirectoryParts";
    private static final String USER_HOME = "user.home";
    private final String containerType;
    private String homeDirectory;
    private String fitframeworkDirectory;
    private String extensionsDirectory;
    private String pluginsDirectory;
    private List<String> pluginDirectories;
    private List<String> sharedDirectories;
    private Matata matata;
    private Server server;
    private Worker worker;
    private Log log;

    public Fit() {
        this.containerType = SPRING;
    }

    @Override
    public List<String> toArgs() {
        ArrayList<String> args = new ArrayList<String>();
        this.initFitDirectory();
        this.buildExtensionsDirectories().ifPresent(args::add);
        this.addSystemPluginsDirs();
        args.add(this.buildRequiredArg(FRAMEWORK_DIRECTORY, this.fitframeworkDirectory));
        args.add(this.buildRequiredArg(FIT_CONTAINER_TYPE, this.containerType));
        this.buildOptionalArg(SHARED_DIRECTORIES, this.buildSharedDirectories()).ifPresent(args::add);
        this.buildOptionalArg(PLUGIN_DIRECTORIES, this.buildPluginDirectories()).ifPresent(args::add);
        Optional.ofNullable(this.matata).map(CommandBuilder::toArgs).ifPresent(args::addAll);
        Optional.ofNullable(this.server).map(CommandBuilder::toArgs).ifPresent(args::addAll);
        Optional.ofNullable(this.worker).map(CommandBuilder::toArgs).ifPresent(args::addAll);
        Optional.ofNullable(this.log).map(CommandBuilder::toArgs).ifPresent(args::addAll);
        return args;
    }

    private void addSystemPluginsDirs() {
        File[] pluginsDirectoryFiles = FileUtils.canonicalize((String)this.pluginsDirectory).listFiles(this::filterPlugins);
        if (pluginsDirectoryFiles != null) {
            if (this.pluginDirectories == null) {
                this.pluginDirectories = new ArrayList<String>();
            }
            this.pluginDirectories.addAll(Arrays.stream(pluginsDirectoryFiles).map(FileUtils::path).collect(Collectors.toList()));
        }
    }

    private Optional<String> buildExtensionsDirectories() {
        File[] extensionsDirectoryFiles = FileUtils.canonicalize((String)this.extensionsDirectory).listFiles(this::filterPlugins);
        if (extensionsDirectoryFiles != null && extensionsDirectoryFiles.length != 0) {
            return Optional.of(this.buildRequiredArg(EXTENSION_DIRECTORIES, Arrays.stream(extensionsDirectoryFiles).map(FileUtils::path).collect(Collectors.joining(DIRECTORY_SEPARATOR))));
        }
        return Optional.empty();
    }

    private boolean filterPlugins(File dir, String name) {
        File file = FileUtils.canonicalize((File)FileUtils.child((File)dir, (String[])new String[]{name, CONF, PLUGIN_PROPERTIES_FILE_NAME}));
        if (!file.isFile()) {
            return false;
        }
        Properties properties = new Properties();
        try (FileInputStream in = new FileInputStream(file);){
            properties.load(in);
        }
        catch (IOException e) {
            throw new FitException(StringUtils.format((String)"Fail to read '{0}'. [plugin={1}]", (Object[])new Object[]{PLUGIN_PROPERTIES_FILE_NAME, name}));
        }
        return Boolean.parseBoolean(String.valueOf(properties.get(PLUGIN_BUILT_IN)));
    }

    private void initFitDirectory() {
        if (StringUtils.isBlank((String)this.homeDirectory)) {
            String fitHomeEnvVar = System.getenv(FIT_HOME);
            if (StringUtils.isBlank((String)fitHomeEnvVar)) {
                throw new FitException("Neither the FIT framework directory was manually specified nor the FIT framework was installed in the default location.");
            }
            this.homeDirectory = fitHomeEnvVar;
        }
        String fitHomeBin = this.homeDirectory + File.separator + BIN;
        this.fitframeworkDirectory = fitHomeBin + File.separator + FITFRAMEWORK;
        this.extensionsDirectory = fitHomeBin + File.separator + EXTENSIONS;
        this.pluginsDirectory = fitHomeBin + File.separator + PLUGINS;
    }

    @Override
    public void accept(Environment env) {
        this.homeDirectory = this.getProperty(FIT_HOME_DIRECTORY, env).orElseGet(this::getHomeDirectory);
        this.validateHomeDirectory(this.homeDirectory);
        logger.info("The fit home directory is {}.", (Object)this.homeDirectory);
        this.pluginDirectories = this.getProperty(FIT_PLUGIN_DIRECTORIES, env).map(directories -> directories.split(DIRECTORY_SEPARATOR)).map(Arrays::asList).orElse(this.pluginDirectories);
        logger.info("The fit plugin directories are {}.", this.pluginDirectories);
        this.sharedDirectories = this.getProperty(FIT_SHARED_DIRECTORIES, env).map(directories -> directories.split(DIRECTORY_SEPARATOR)).map(Arrays::asList).orElse(this.sharedDirectories);
        logger.info("The fit shared directories are {}.", this.sharedDirectories);
        this.matata = (Matata)ObjectUtils.getIfNull((Object)this.matata, Matata::new);
        this.server = (Server)ObjectUtils.getIfNull((Object)this.server, Server::new);
        this.worker = (Worker)ObjectUtils.getIfNull((Object)this.worker, Worker::new);
        this.log = (Log)ObjectUtils.getIfNull((Object)this.log, Log::new);
        this.matata.accept(env);
        this.server.accept(env);
        this.worker.accept(env);
        this.log.accept(env);
    }

    private void validateHomeDirectory(String homeDirectory) {
        File directory = new File(homeDirectory);
        if (!directory.isDirectory()) {
            throw new IllegalStateException(StringUtils.format((String)"Fail to startup fitframework: config of 'fit.homeDirectory' is not a directory. [fit.homeDirectory={0}]", (Object[])new Object[]{homeDirectory}));
        }
    }

    private String getHomeDirectory() {
        return Optional.ofNullable(this.homeDirectory).orElseGet(this::buildDefaultHomeDirectory);
    }

    private String buildDefaultHomeDirectory() {
        DefaultFitFrameworkVersion fitFrameworkVersion = new DefaultFitFrameworkVersion(GROUP_ID, ARTIFACT_ID);
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(System.getProperty(USER_HOME));
        parts.addAll(this.getDefaultHomeDirectoryParts());
        parts.add(fitFrameworkVersion.getVersionString());
        String defaultHomeDirectory = StringUtils.join((String)File.separator, parts);
        logger.info("Use default fit home directory. [homeDirectory={}]", (Object)defaultHomeDirectory);
        return defaultHomeDirectory;
    }

    private List<String> getDefaultHomeDirectoryParts() {
        InputStream in = FitConfiguration.class.getClassLoader().getResourceAsStream(CONFIG_PROPERTIES);
        return (List)PropertiesUtils.mapFrom((InputStream)in).get(DEFAULT_HOME_DIRECTORY_PARTS_KEY);
    }

    private String buildSharedDirectories() {
        return CollectionUtils.isEmpty(this.sharedDirectories) ? null : String.join((CharSequence)DIRECTORY_SEPARATOR, this.sharedDirectories);
    }

    private String buildPluginDirectories() {
        if (CollectionUtils.isEmpty(this.pluginDirectories)) {
            return null;
        }
        return String.join((CharSequence)DIRECTORY_SEPARATOR, this.pluginDirectories);
    }

    @Generated
    public String getContainerType() {
        return this.containerType;
    }

    @Generated
    public String getFitframeworkDirectory() {
        return this.fitframeworkDirectory;
    }

    @Generated
    public String getExtensionsDirectory() {
        return this.extensionsDirectory;
    }

    @Generated
    public String getPluginsDirectory() {
        return this.pluginsDirectory;
    }

    @Generated
    public List<String> getPluginDirectories() {
        return this.pluginDirectories;
    }

    @Generated
    public List<String> getSharedDirectories() {
        return this.sharedDirectories;
    }

    @Generated
    public Matata getMatata() {
        return this.matata;
    }

    @Generated
    public Server getServer() {
        return this.server;
    }

    @Generated
    public Worker getWorker() {
        return this.worker;
    }

    @Generated
    public Log getLog() {
        return this.log;
    }

    @Generated
    public void setHomeDirectory(String homeDirectory) {
        this.homeDirectory = homeDirectory;
    }

    @Generated
    public void setFitframeworkDirectory(String fitframeworkDirectory) {
        this.fitframeworkDirectory = fitframeworkDirectory;
    }

    @Generated
    public void setExtensionsDirectory(String extensionsDirectory) {
        this.extensionsDirectory = extensionsDirectory;
    }

    @Generated
    public void setPluginsDirectory(String pluginsDirectory) {
        this.pluginsDirectory = pluginsDirectory;
    }

    @Generated
    public void setPluginDirectories(List<String> pluginDirectories) {
        this.pluginDirectories = pluginDirectories;
    }

    @Generated
    public void setSharedDirectories(List<String> sharedDirectories) {
        this.sharedDirectories = sharedDirectories;
    }

    @Generated
    public void setMatata(Matata matata) {
        this.matata = matata;
    }

    @Generated
    public void setServer(Server server) {
        this.server = server;
    }

    @Generated
    public void setWorker(Worker worker) {
        this.worker = worker;
    }

    @Generated
    public void setLog(Log log) {
        this.log = log;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Fit)) {
            return false;
        }
        Fit other = (Fit)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$containerType = this.getContainerType();
        String other$containerType = other.getContainerType();
        if (this$containerType == null ? other$containerType != null : !this$containerType.equals(other$containerType)) {
            return false;
        }
        String this$homeDirectory = this.getHomeDirectory();
        String other$homeDirectory = other.getHomeDirectory();
        if (this$homeDirectory == null ? other$homeDirectory != null : !this$homeDirectory.equals(other$homeDirectory)) {
            return false;
        }
        String this$fitframeworkDirectory = this.getFitframeworkDirectory();
        String other$fitframeworkDirectory = other.getFitframeworkDirectory();
        if (this$fitframeworkDirectory == null ? other$fitframeworkDirectory != null : !this$fitframeworkDirectory.equals(other$fitframeworkDirectory)) {
            return false;
        }
        String this$extensionsDirectory = this.getExtensionsDirectory();
        String other$extensionsDirectory = other.getExtensionsDirectory();
        if (this$extensionsDirectory == null ? other$extensionsDirectory != null : !this$extensionsDirectory.equals(other$extensionsDirectory)) {
            return false;
        }
        String this$pluginsDirectory = this.getPluginsDirectory();
        String other$pluginsDirectory = other.getPluginsDirectory();
        if (this$pluginsDirectory == null ? other$pluginsDirectory != null : !this$pluginsDirectory.equals(other$pluginsDirectory)) {
            return false;
        }
        List<String> this$pluginDirectories = this.getPluginDirectories();
        List<String> other$pluginDirectories = other.getPluginDirectories();
        if (this$pluginDirectories == null ? other$pluginDirectories != null : !((Object)this$pluginDirectories).equals(other$pluginDirectories)) {
            return false;
        }
        List<String> this$sharedDirectories = this.getSharedDirectories();
        List<String> other$sharedDirectories = other.getSharedDirectories();
        if (this$sharedDirectories == null ? other$sharedDirectories != null : !((Object)this$sharedDirectories).equals(other$sharedDirectories)) {
            return false;
        }
        Matata this$matata = this.getMatata();
        Matata other$matata = other.getMatata();
        if (this$matata == null ? other$matata != null : !((Object)this$matata).equals(other$matata)) {
            return false;
        }
        Server this$server = this.getServer();
        Server other$server = other.getServer();
        if (this$server == null ? other$server != null : !((Object)this$server).equals(other$server)) {
            return false;
        }
        Worker this$worker = this.getWorker();
        Worker other$worker = other.getWorker();
        if (this$worker == null ? other$worker != null : !((Object)this$worker).equals(other$worker)) {
            return false;
        }
        Log this$log = this.getLog();
        Log other$log = other.getLog();
        return !(this$log == null ? other$log != null : !((Object)this$log).equals(other$log));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Fit;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $containerType = this.getContainerType();
        result = result * 59 + ($containerType == null ? 43 : $containerType.hashCode());
        String $homeDirectory = this.getHomeDirectory();
        result = result * 59 + ($homeDirectory == null ? 43 : $homeDirectory.hashCode());
        String $fitframeworkDirectory = this.getFitframeworkDirectory();
        result = result * 59 + ($fitframeworkDirectory == null ? 43 : $fitframeworkDirectory.hashCode());
        String $extensionsDirectory = this.getExtensionsDirectory();
        result = result * 59 + ($extensionsDirectory == null ? 43 : $extensionsDirectory.hashCode());
        String $pluginsDirectory = this.getPluginsDirectory();
        result = result * 59 + ($pluginsDirectory == null ? 43 : $pluginsDirectory.hashCode());
        List<String> $pluginDirectories = this.getPluginDirectories();
        result = result * 59 + ($pluginDirectories == null ? 43 : ((Object)$pluginDirectories).hashCode());
        List<String> $sharedDirectories = this.getSharedDirectories();
        result = result * 59 + ($sharedDirectories == null ? 43 : ((Object)$sharedDirectories).hashCode());
        Matata $matata = this.getMatata();
        result = result * 59 + ($matata == null ? 43 : ((Object)$matata).hashCode());
        Server $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : ((Object)$server).hashCode());
        Worker $worker = this.getWorker();
        result = result * 59 + ($worker == null ? 43 : ((Object)$worker).hashCode());
        Log $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : ((Object)$log).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Fit(containerType=" + this.getContainerType() + ", homeDirectory=" + this.getHomeDirectory() + ", fitframeworkDirectory=" + this.getFitframeworkDirectory() + ", extensionsDirectory=" + this.getExtensionsDirectory() + ", pluginsDirectory=" + this.getPluginsDirectory() + ", pluginDirectories=" + this.getPluginDirectories() + ", sharedDirectories=" + this.getSharedDirectories() + ", matata=" + this.getMatata() + ", server=" + this.getServer() + ", worker=" + this.getWorker() + ", log=" + this.getLog() + ")";
    }
}

