/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.spring.config;

import com.huawei.fitframework.core.common.util.LockUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.PropertiesUtils;
import com.huawei.fitframework.core.common.util.ReflectionUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.spring.config.Fit;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class FitConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FitConfiguration.class);
    private static final String FIT_CONFIG_PROPERTIES = "fit.properties";
    private static final String FIT_DEFAULT_CONFIG_PROPERTIES = "default-fit.properties";
    private static final Object LOCK = LockUtils.newSynchronizedLock();
    private static volatile FitConfiguration instance;
    private Fit fit = new Fit();

    private FitConfiguration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FitConfiguration instance() {
        if (instance == null) {
            Object object = LOCK;
            synchronized (object) {
                if (instance == null) {
                    instance = FitConfiguration.load();
                }
            }
        }
        return instance;
    }

    private static FitConfiguration load() {
        FitConfiguration defaultFitConfiguration = FitConfiguration.getFitConfiguration(FIT_DEFAULT_CONFIG_PROPERTIES);
        FitConfiguration customFitConfiguration = FitConfiguration.getFitConfiguration(FIT_CONFIG_PROPERTIES);
        Fit defaultFit = defaultFitConfiguration.getFit();
        Fit customFit = customFitConfiguration.getFit();
        FitConfiguration.setDefaultValueIfNull(customFit, defaultFit);
        customFit.getServer().init();
        return customFitConfiguration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static FitConfiguration getFitConfiguration(String resourceName) {
        try (InputStream input = FitConfiguration.class.getClassLoader().getResourceAsStream(resourceName);){
            FitConfiguration fitConfiguration = Optional.ofNullable(input).map(in -> FitConfiguration.mapToObject(FitConfiguration.class, PropertiesUtils.mapFrom((InputStream)input))).orElseGet(FitConfiguration::new);
            return fitConfiguration;
        }
        catch (IOException e) {
            log.warn("Fail to get fit configuration. [file={}]", (Object)resourceName);
            throw new IllegalStateException("Fail to get fit configuration.", e);
        }
    }

    private static <T> T mapToObject(Class<T> cls, Map<String, Object> map) {
        Object obj = ReflectionUtils.instantiate(cls);
        Arrays.stream(cls.getDeclaredFields()).filter(field -> map.containsKey(field.getName())).forEach(field -> FitConfiguration.setField(obj, field, map));
        return (T)obj;
    }

    private static void setField(Object obj, Field field, Map<String, Object> map) {
        Object value = map.get(field.getName());
        Class<Map> fieldCls = field.getType();
        if (value instanceof Map && !fieldCls.isAssignableFrom(Map.class)) {
            ReflectionUtils.setField((Object)obj, (Field)field, FitConfiguration.mapToObject(fieldCls, (Map)value));
        } else {
            ReflectionUtils.setField((Object)obj, (Field)field, (Object)value);
        }
    }

    private static void setDefaultValueIfNull(Fit customFit, Fit defaultFit) {
        if (customFit.getMatata() == null) {
            customFit.setMatata(defaultFit.getMatata());
        }
        if (customFit.getServer() == null) {
            customFit.setServer(defaultFit.getServer());
        }
        if (customFit.getWorker() == null) {
            customFit.setWorker(defaultFit.getWorker());
        }
        if (customFit.getLog() == null) {
            customFit.setLog(defaultFit.getLog());
        }
    }

    public String[] buildArgs(Environment environment) {
        Validation.notNull((Object)environment, (String)"No environment.", (Object[])new Object[0]);
        this.fit = (Fit)ObjectUtils.getIfNull((Object)this.fit, Fit::new);
        this.fit.accept(environment);
        return this.fit.toArgs().toArray(new String[0]);
    }

    @Generated
    public Fit getFit() {
        return this.fit;
    }

    @Generated
    public void setFit(Fit fit) {
        this.fit = fit;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FitConfiguration)) {
            return false;
        }
        FitConfiguration other = (FitConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Fit this$fit = this.getFit();
        Fit other$fit = other.getFit();
        return !(this$fit == null ? other$fit != null : !((Object)this$fit).equals(other$fit));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FitConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Fit $fit = this.getFit();
        result = result * 59 + ($fit == null ? 43 : ((Object)$fit).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FitConfiguration(fit=" + this.getFit() + ")";
    }
}

