/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.spring.config;

import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.spring.config.CommandBuilder;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class Server
implements CommandBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Server.class);
    private static final String SERVER_ID = "server.id";
    private static final String SERVER_HOST = "server.host";
    private static final String SERVER_HTTP_PORT = "server.http.port";
    private static final String SERVER_RSOCKET_PORT = "server.rsocket.port";
    private static final String SERVER_GRPC_PORT = "server.grpc.port";
    private static final String FIT_SERVER_ID = "fit.server.id";
    private static final String FIT_SERVER_HOST = "fit.server.host";
    private static final String FIT_SERVER_HTTP_PORT = "fit.server.httpPort";
    private static final String FIT_SERVER_RSOCKET_PORT = "fit.server.rsocketPort";
    private static final String FIT_SERVER_GRPC_PORT = "fit.server.grpcPort";
    private static final String USER_NAME = "user.name";
    private static final String ID_DELIMITER = "-";
    private static final int END_INDEX = 10;
    private static final int BEGIN_INDEX = 0;
    private static final String ID_PREFIX = "worker-id";
    private String id;
    private String host;
    private String httpPort;
    private String rsocketPort;
    private String grpcPort;

    public void init() {
        this.host = this.initHost(this.host);
        this.id = this.initWorkerId(this.host, this.id);
    }

    private String initHost(String host) {
        if (StringUtils.isNotBlank((String)host)) {
            return host;
        }
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            log.warn("Fail to get local host address.");
            throw new IllegalStateException("Fail to get local host address.", e);
        }
    }

    private String initWorkerId(String host, String workerId) {
        if (StringUtils.isNotBlank((String)workerId)) {
            return workerId;
        }
        return String.join((CharSequence)ID_DELIMITER, ID_PREFIX, System.getProperty(USER_NAME), host, UUID.randomUUID().toString().replaceAll(ID_DELIMITER, "").substring(0, 10));
    }

    @Override
    public List<String> toArgs() {
        ArrayList<String> args = new ArrayList<String>();
        this.buildOptionalArg(SERVER_ID, this.id).ifPresent(args::add);
        this.buildOptionalArg(SERVER_HOST, this.host).ifPresent(args::add);
        this.buildOptionalArg(SERVER_HTTP_PORT, this.httpPort).ifPresent(args::add);
        this.buildOptionalArg(SERVER_RSOCKET_PORT, this.rsocketPort).ifPresent(args::add);
        this.buildOptionalArg(SERVER_GRPC_PORT, this.grpcPort).ifPresent(args::add);
        return args;
    }

    @Override
    public void accept(Environment env) {
        this.id = this.getProperty(FIT_SERVER_ID, env).orElse(this.id);
        this.host = this.getProperty(FIT_SERVER_HOST, env).orElse(this.host);
        this.httpPort = this.getProperty(FIT_SERVER_HTTP_PORT, env).orElse(this.httpPort);
        this.rsocketPort = this.getProperty(FIT_SERVER_RSOCKET_PORT, env).orElse(this.rsocketPort);
        this.grpcPort = this.getProperty(FIT_SERVER_GRPC_PORT, env).orElse(this.grpcPort);
    }

    @Generated
    public Server() {
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public String getHttpPort() {
        return this.httpPort;
    }

    @Generated
    public String getRsocketPort() {
        return this.rsocketPort;
    }

    @Generated
    public String getGrpcPort() {
        return this.grpcPort;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public void setHttpPort(String httpPort) {
        this.httpPort = httpPort;
    }

    @Generated
    public void setRsocketPort(String rsocketPort) {
        this.rsocketPort = rsocketPort;
    }

    @Generated
    public void setGrpcPort(String grpcPort) {
        this.grpcPort = grpcPort;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Server)) {
            return false;
        }
        Server other = (Server)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$httpPort = this.getHttpPort();
        String other$httpPort = other.getHttpPort();
        if (this$httpPort == null ? other$httpPort != null : !this$httpPort.equals(other$httpPort)) {
            return false;
        }
        String this$rsocketPort = this.getRsocketPort();
        String other$rsocketPort = other.getRsocketPort();
        if (this$rsocketPort == null ? other$rsocketPort != null : !this$rsocketPort.equals(other$rsocketPort)) {
            return false;
        }
        String this$grpcPort = this.getGrpcPort();
        String other$grpcPort = other.getGrpcPort();
        return !(this$grpcPort == null ? other$grpcPort != null : !this$grpcPort.equals(other$grpcPort));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Server;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $httpPort = this.getHttpPort();
        result = result * 59 + ($httpPort == null ? 43 : $httpPort.hashCode());
        String $rsocketPort = this.getRsocketPort();
        result = result * 59 + ($rsocketPort == null ? 43 : $rsocketPort.hashCode());
        String $grpcPort = this.getGrpcPort();
        result = result * 59 + ($grpcPort == null ? 43 : $grpcPort.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Server(id=" + this.getId() + ", host=" + this.getHost() + ", httpPort=" + this.getHttpPort() + ", rsocketPort=" + this.getRsocketPort() + ", grpcPort=" + this.getGrpcPort() + ")";
    }
}

