/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.spring.inject;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Value;
import com.huawei.fitframework.core.common.util.ReflectionUtils;
import com.huawei.fitframework.runtime.proxy.ProxyContext;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class FitInjectProcessor
implements BeanPostProcessor,
Ordered {
    private final Set<InjectTask> fitInjectTaskSet = new HashSet<InjectTask>();
    private final Set<InjectTask> valueInjectTaskSet = new HashSet<InjectTask>();

    public Object postProcessAfterInitialization(Object bean, @NonNull String beanName) throws BeansException {
        Field[] declaredFields = bean.getClass().getDeclaredFields();
        Stream.of(declaredFields).filter(field -> field.isAnnotationPresent(Fit.class)).map(field -> new InjectTask(bean, beanName, (Field)field)).forEach(this.fitInjectTaskSet::add);
        Stream.of(declaredFields).filter(field -> field.isAnnotationPresent(Value.class)).map(field -> new InjectTask(bean, beanName, (Field)field)).forEach(this.valueInjectTaskSet::add);
        return bean;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void autowireFitField(ProxyContext context) {
        this.fitInjectTaskSet.forEach(injectTask -> {
            Object proxy = context.getFitProxy(((InjectTask)injectTask).bean, ((InjectTask)injectTask).beanName, ((InjectTask)injectTask).field);
            ReflectionUtils.setField((Object)((InjectTask)injectTask).bean, (Field)((InjectTask)injectTask).field, (Object)proxy);
        });
    }

    public void autowireValueField(ProxyContext context) {
        this.valueInjectTaskSet.forEach(injectTask -> {
            Object proxy = context.getConfigValue(((InjectTask)injectTask).bean, ((InjectTask)injectTask).beanName, ((InjectTask)injectTask).field);
            ReflectionUtils.setField((Object)((InjectTask)injectTask).bean, (Field)((InjectTask)injectTask).field, (Object)proxy);
        });
    }

    private static class InjectTask {
        private final Object bean;
        private final String beanName;
        private final Field field;

        public InjectTask(Object bean, String beanName, Field field) {
            this.bean = bean;
            this.beanName = beanName;
            this.field = field;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InjectTask)) {
                return false;
            }
            InjectTask other = (InjectTask)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Object this$bean = this.bean;
            Object other$bean = other.bean;
            if (this$bean == null ? other$bean != null : !this$bean.equals(other$bean)) {
                return false;
            }
            String this$beanName = this.beanName;
            String other$beanName = other.beanName;
            if (this$beanName == null ? other$beanName != null : !this$beanName.equals(other$beanName)) {
                return false;
            }
            Field this$field = this.field;
            Field other$field = other.field;
            return !(this$field == null ? other$field != null : !((Object)this$field).equals(other$field));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InjectTask;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $bean = this.bean;
            result = result * 59 + ($bean == null ? 43 : $bean.hashCode());
            String $beanName = this.beanName;
            result = result * 59 + ($beanName == null ? 43 : $beanName.hashCode());
            Field $field = this.field;
            result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
            return result;
        }
    }
}

