/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.spring.listener;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.FileUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.launch.FitLauncher;
import com.huawei.fitframework.runtime.FitContext;
import com.huawei.fitframework.spring.config.FitConfiguration;
import com.huawei.fitframework.spring.inject.FitInjectProcessor;
import com.huawei.fitframework.spring.loader.SpringSharedClassLoader;
import java.io.File;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class FitStarter
implements ApplicationListener<ContextRefreshedEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FitStarter.class);
    private static final String SPRING_PLUGIN_NAME = "spring";
    private static final String SHARED_DIRECTORY = "shared";
    private static final String PLUGINS_DIRECTORY = "plugins";
    private static final String KEY_APP_NAME = "app.name";
    private static final String VALUE_APP_NAME = "fit-spring";
    private final FitInjectProcessor fitInjectProcessor;
    private boolean isStarted = false;

    public FitStarter(FitInjectProcessor fitInjectProcessor) {
        this.fitInjectProcessor = fitInjectProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext().getParent() != null) {
            return;
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            FitContext fitContext = this.startFit(event);
            this.loadSpringAsPlugin(event, fitContext);
            this.fitInjectProcessor.autowireFitField(fitContext.getProxyContext());
            this.fitInjectProcessor.autowireValueField(fitContext.getProxyContext());
            this.isStarted = true;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private void loadSpringAsPlugin(ContextRefreshedEvent event, FitContext fitContext) {
        List<Object> list = this.getFitableObjectList(event);
        fitContext.getPluginContext().addPlugin(SPRING_PLUGIN_NAME, list);
        SpringSharedClassLoader sharedClassLoader = (SpringSharedClassLoader)ObjectUtils.cast((Object)fitContext.getSharedClassLoader());
        fitContext.getPluginContext().addConfiguration(sharedClassLoader.getExternalClassLoader());
        fitContext.getPluginContext().registerGenericables(sharedClassLoader.getGenericableClasses());
    }

    private List<Object> getFitableObjectList(ContextRefreshedEvent event) {
        List<Object> fitableSuiteList = this.getBeanListByAnnotation(event, FitableSuite.class);
        List<Object> fitableList = this.getBeanListByAnnotation(event, Fitable.class);
        return CollectionUtils.connect((List[])new List[]{fitableSuiteList, fitableList});
    }

    private List<Object> getBeanListByAnnotation(ContextRefreshedEvent event, Class<? extends Annotation> annotationClz) {
        return new ArrayList<Object>(event.getApplicationContext().getBeansWithAnnotation(annotationClz).values());
    }

    private FitContext startFit(ContextRefreshedEvent event) {
        this.setAppName();
        Environment environment = event.getApplicationContext().getEnvironment();
        String[] args = FitConfiguration.instance().buildArgs(environment);
        SpringSharedClassLoader sharedClassLoader = this.create(args);
        return (FitContext)ObjectUtils.cast((Object)FitLauncher.start((String[])args, (ClassLoader)sharedClassLoader));
    }

    private void setAppName() {
        String appName = System.getProperty(KEY_APP_NAME);
        if (StringUtils.isBlank((String)appName)) {
            System.setProperty(KEY_APP_NAME, VALUE_APP_NAME);
        }
    }

    private SpringSharedClassLoader create(String[] args) {
        SpringSharedClassLoader sharedClassLoader = SpringSharedClassLoader.create(this.getSharedDirectories(args), Thread.currentThread().getContextClassLoader());
        List<File> specialFiles = this.getSpecialPriorityJar(args);
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File specialFile : specialFiles) {
            try {
                urls.add(specialFile.toURI().toURL());
            }
            catch (MalformedURLException e) {
                log.warn("Fail to add url to SpringSharedClassLoader. [url={}]", (Object)specialFile.getName());
            }
        }
        sharedClassLoader.addPriorityClasses(urls);
        return sharedClassLoader;
    }

    private List<File> getSharedDirectories(String[] args) {
        ArrayList<File> sharedDirectories = new ArrayList<File>();
        sharedDirectories.add(new File(this.getFrameworkDirectory(args), SHARED_DIRECTORY));
        this.getAllPluginDirectories(args).stream().filter(Objects::nonNull).map(plugin -> new File((File)plugin, SHARED_DIRECTORY)).forEach(sharedDirectories::add);
        return sharedDirectories;
    }

    private List<File> getSpecialPriorityJar(String[] args) {
        List<File> pluginDirectories = this.getAllPluginDirectories(args);
        return pluginDirectories.stream().flatMap(FileUtils::traverse).filter(file -> file.getName().startsWith("tomcat-embed-core")).collect(Collectors.toList());
    }

    private File getFrameworkDirectory(String[] args) {
        return FileUtils.canonicalize((File)new File(Stream.of(args).filter(Objects::nonNull).filter(arg -> arg.startsWith("framework.directory=")).findFirst().map(arg -> arg.substring(arg.indexOf("=") + 1)).map(String::trim).filter(value -> !value.isEmpty()).orElse(".")));
    }

    private List<File> getAllPluginDirectories(String[] args) {
        ArrayList<File> pluginDirectories = new ArrayList<File>();
        pluginDirectories.addAll(this.getFrameworkPluginDirectories(args));
        pluginDirectories.addAll(this.getPluginDirectories(args));
        return pluginDirectories;
    }

    private List<File> getFrameworkPluginDirectories(String[] args) {
        File frameworkPluginParent = new File(this.getFrameworkDirectory(args), PLUGINS_DIRECTORY);
        return Stream.of((Object[])ObjectUtils.nullIf((Object)frameworkPluginParent.listFiles(), (Object)new File[0])).collect(Collectors.toList());
    }

    private List<File> getPluginDirectories(String[] args) {
        String[] plugins = Stream.of(args).filter(Objects::nonNull).filter(arg -> arg.startsWith("plugin.directories=")).findFirst().map(arg -> arg.substring(arg.indexOf("=") + 1)).map(String::trim).filter(value -> !value.isEmpty()).map(value -> value.split(",")).orElseGet(() -> new String[0]);
        return Stream.of(plugins).filter(StringUtils::isNotBlank).map(File::new).map(FileUtils::canonicalize).collect(Collectors.toList());
    }

    @Generated
    public boolean isStarted() {
        return this.isStarted;
    }
}

