/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.spring.loader;

import com.huawei.fitframework.core.common.util.ClassScanner;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.UrlUtils;
import com.huawei.fitframework.core.common.util.support.UrlClassLoaderScanner;
import com.huawei.fitframework.launch.util.ClassLoaderUtils;
import com.huawei.fitframework.launch.util.FileUtils;
import com.huawei.fitframework.spring.scan.GenericableScanner;
import java.io.File;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class SpringSharedClassLoader
extends URLClassLoader {
    private static final List<String> DEFAULT_PARENT_CLASS_LOADER_NAMES = Arrays.asList("ExtClassLoader", "PlatformClassLoader");
    private static final Set<String> EXCLUDED_JAR_FILE_NAME_PREFIXES = new HashSet<String>(Arrays.asList("fit-api", "fit-runtime-api", "fit-http-message-api", "fit-util", "javax.servlet-api"));
    private static final String FILE_PROTOCOL = "file";
    private static final String JAR_PROTOCOL = "jar";
    private final ClassLoader externalClassLoader;
    private final Set<Class<?>> genericableClasses = new HashSet();
    private final Set<String> excludedClasses = new HashSet<String>();
    private final Set<String> priorityClasses = new HashSet<String>();
    private final Set<String> priorityPackages = new HashSet<String>();

    private SpringSharedClassLoader(URL[] urls, ClassLoader parent, ClassLoader externalClassLoader) {
        super(SpringSharedClassLoader.filterExcludedUrls(urls), parent);
        this.externalClassLoader = externalClassLoader;
        this.scanExcludedClasses(urls);
        this.scanPriorityClasses(urls);
        this.scanPriorityClasses(externalClassLoader);
        this.initPriorityPackages();
    }

    private static URL[] filterExcludedUrls(URL[] urls) {
        return (URL[])Stream.of(urls).filter(Objects::nonNull).filter(url -> !SpringSharedClassLoader.isExcludedUrl(url)).toArray(URL[]::new);
    }

    private static boolean isExcludedUrl(URL url) {
        for (String excludedJarFileNamePrefix : EXCLUDED_JAR_FILE_NAME_PREFIXES) {
            try {
                String fileName = Paths.get(url.toURI()).toFile().getName();
                if (!fileName.startsWith(excludedJarFileNamePrefix)) continue;
                return true;
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(StringUtils.format((String)"URL is illegal. [url={0}]", (Object[])new Object[]{url}), e);
            }
        }
        return false;
    }

    private static boolean isPriorityUrl(URL url) {
        String fileName = SpringSharedClassLoader.getFileName(url);
        return SpringSharedClassLoader.isGenericable(fileName) || SpringSharedClassLoader.isComponent(fileName) || SpringSharedClassLoader.isSpecialPriorityUrl(fileName);
    }

    private static String getFileName(URL url) {
        try {
            if (Objects.equals(url.getProtocol(), FILE_PROTOCOL)) {
                return Paths.get(url.toURI()).toFile().getName();
            }
            if (Objects.equals(url.getProtocol(), JAR_PROTOCOL)) {
                return SpringSharedClassLoader.getFileNameFromProtocolJar(url);
            }
            return "";
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(StringUtils.format((String)"Fail to get file name. [url={0}]", (Object[])new Object[]{url.toExternalForm()}), e);
        }
    }

    private static String getFileNameFromProtocolJar(URL url) {
        String path = url.getPath();
        if (StringUtils.isBlank((String)path)) {
            return "";
        }
        int end = path.lastIndexOf("!/");
        if (end == -1) {
            return "";
        }
        int start = path.substring(0, path.length() - 1).lastIndexOf("/") + 1;
        if (start >= end) {
            return "";
        }
        return path.substring(start, end);
    }

    private static boolean isGenericable(String fileName) {
        return StringUtils.isNotBlank((String)fileName) && fileName.startsWith("genericable-");
    }

    private static boolean isComponent(String fileName) {
        return StringUtils.isNotBlank((String)fileName) && fileName.startsWith("component-");
    }

    private static boolean isSpecialPriorityUrl(String fileName) {
        return StringUtils.isNotBlank((String)fileName) && fileName.startsWith("tomcat-embed-core");
    }

    private void scanExcludedClasses(URL[] urls) {
        UrlClassLoaderScanner scanner = new UrlClassLoaderScanner(new URLClassLoader(urls), SpringSharedClassLoader::isExcludedUrl);
        scanner.addClassDetectedObserver(this.excludedClasses::add);
        scanner.scan();
    }

    private void scanPriorityClasses(URL[] urls) {
        UrlClassLoaderScanner scanner = new UrlClassLoaderScanner(new URLClassLoader(urls), SpringSharedClassLoader::isPriorityUrl);
        scanner.addClassDetectedObserver(this.priorityClasses::add);
        scanner.scan();
    }

    private void scanPriorityClasses(ClassLoader externalClassLoader) {
        Set<URL> dependencyUrls = this.getDependencyUrls(externalClassLoader);
        UrlClassLoaderScanner scanner = new UrlClassLoaderScanner(new URLClassLoader(dependencyUrls.toArray(new URL[0])), url -> this.dependencyUrlFilter((URL)url, dependencyUrls));
        scanner.addClassDetectedObserver(this.priorityClasses::add);
        GenericableScanner genericableScanner = new GenericableScanner((ClassScanner)scanner);
        genericableScanner.scan();
        this.genericableClasses.addAll(genericableScanner.getGenericableClasses());
    }

    private boolean dependencyUrlFilter(URL url, Set<URL> dependencyUrls) {
        return SpringSharedClassLoader.isPriorityUrl(url) || dependencyUrls.size() == 1 && dependencyUrls.contains(url);
    }

    private Set<URL> getDependencyUrls(ClassLoader externalClassLoader) {
        if (!(externalClassLoader instanceof URLClassLoader)) {
            return Collections.emptySet();
        }
        return Arrays.stream(((URLClassLoader)ObjectUtils.cast((Object)externalClassLoader)).getURLs()).filter(url -> UrlUtils.isJar((URL)url) || UrlUtils.isJarInJar((URL)url)).collect(Collectors.toSet());
    }

    private void initPriorityPackages() {
        this.priorityPackages.add("org.aopalliance");
        this.priorityPackages.add("org.apache.commons.logging");
        this.priorityPackages.add("org.springframework");
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.excludedClasses.contains(name)) {
            return this.externalClassLoader.loadClass(name);
        }
        if (this.priorityClasses.contains(name)) {
            return this.priorityLoadClass(name);
        }
        for (String priorityLoadedPackage : this.priorityPackages) {
            if (!name.startsWith(priorityLoadedPackage)) continue;
            return this.priorityLoadClass(name);
        }
        return super.findClass(name);
    }

    private Class<?> priorityLoadClass(String name) throws ClassNotFoundException {
        try {
            return this.externalClassLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return super.findClass(name);
        }
    }

    public void addPriorityClasses(Collection<URL> jarFiles) {
        this.scanPriorityClasses(jarFiles.toArray(new URL[0]));
    }

    @Override
    public void addURL(URL url) {
        if (SpringSharedClassLoader.isExcludedUrl(url)) {
            return;
        }
        super.addURL(url);
    }

    public static SpringSharedClassLoader create(List<File> sharedDirectories, ClassLoader externalClassLoader) {
        ClassLoader parentLoader = ClassLoaderUtils.lookupClassLoader(classLoader -> DEFAULT_PARENT_CLASS_LOADER_NAMES.contains(classLoader.getClass().getSimpleName()));
        return new SpringSharedClassLoader(FileUtils.resolveJarUrls(sharedDirectories), parentLoader, externalClassLoader);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return (InputStream)ObjectUtils.getIfNull((Object)super.getResourceAsStream(name), () -> this.externalClassLoader.getResourceAsStream(name));
    }

    @Generated
    public ClassLoader getExternalClassLoader() {
        return this.externalClassLoader;
    }

    @Generated
    public Set<Class<?>> getGenericableClasses() {
        return this.genericableClasses;
    }
}

