/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.spring.scan;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class FitBeanDefinitionScanner
extends ClassPathBeanDefinitionScanner {
    private List<String> excludePackages = Collections.emptyList();
    private List<Class<? extends Annotation>> includeAnnotations = Collections.emptyList();
    private List<Class<? extends Annotation>> excludeAnnotations = Collections.emptyList();

    public FitBeanDefinitionScanner(BeanDefinitionRegistry registry, boolean useDefaultFilters) {
        super(registry, useDefaultFilters);
    }

    protected Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        this.includeAnnotations.forEach(annotation -> this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(annotation)));
        this.excludeAnnotations.forEach(annotation -> this.addExcludeFilter((TypeFilter)new AnnotationTypeFilter(annotation)));
        this.addExcludeFilter((metadataReader, metadataReaderFactory) -> this.filterPackage(metadataReader));
        return super.doScan(basePackages);
    }

    public void setExcludePackages(String[] excludePackages) {
        this.excludePackages = Arrays.asList(excludePackages);
    }

    private boolean filterPackage(MetadataReader metadataReader) {
        String className = metadataReader.getClassMetadata().getClassName();
        return this.excludePackages.stream().anyMatch(className::startsWith);
    }

    @Generated
    public void setIncludeAnnotations(List<Class<? extends Annotation>> includeAnnotations) {
        this.includeAnnotations = includeAnnotations;
    }

    @Generated
    public void setExcludeAnnotations(List<Class<? extends Annotation>> excludeAnnotations) {
        this.excludeAnnotations = excludeAnnotations;
    }
}

