/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.spring.scan;

import com.huawei.fitframework.spring.scan.FitBeanDefinitionScanner;
import com.huawei.fitframework.spring.scan.FitBeanNameGenerator;
import com.huawei.fitframework.spring.scan.FitBeanScan;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.lang.NonNull;

public class FitBeanScannerRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware {
    private static final String BASE_PACKAGE = "basePackage";
    private static final String EXCLUDE_PACKAGE = "excludePackage";
    private static final String INCLUDE_ANNOTATION = "includeAnnotation";
    private static final String EXCLUDE_ANNOTATION = "excludeAnnotation";
    private ResourceLoader resourceLoader;

    public void setResourceLoader(@NonNull ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, @NonNull BeanDefinitionRegistry beanDefinitionRegistry) {
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)annotationMetadata.getAnnotationAttributes(FitBeanScan.class.getName()));
        if (attributes == null) {
            return;
        }
        FitBeanDefinitionScanner scanHandler = this.createScanHandler(beanDefinitionRegistry, attributes);
        scanHandler.doScan(this.getPackage(attributes, BASE_PACKAGE));
    }

    private FitBeanDefinitionScanner createScanHandler(BeanDefinitionRegistry beanDefinitionRegistry, AnnotationAttributes attributes) {
        FitBeanDefinitionScanner scanHandle = new FitBeanDefinitionScanner(beanDefinitionRegistry, false);
        if (this.resourceLoader != null) {
            scanHandle.setResourceLoader(this.resourceLoader);
        }
        scanHandle.setBeanNameGenerator((BeanNameGenerator)new FitBeanNameGenerator());
        scanHandle.setExcludePackages(this.getPackage(attributes, EXCLUDE_PACKAGE));
        scanHandle.setIncludeAnnotations(this.getAnnotationAttributes(attributes, INCLUDE_ANNOTATION));
        scanHandle.setExcludeAnnotations(this.getAnnotationAttributes(attributes, EXCLUDE_ANNOTATION));
        return scanHandle;
    }

    private List<Class<? extends Annotation>> getAnnotationAttributes(AnnotationAttributes attrs, String key) {
        Class[] annotationArray = attrs.getClassArray(key);
        if (annotationArray.length == 0) {
            annotationArray = new Class[]{};
        }
        return Arrays.stream(annotationArray).map(clazz -> clazz).collect(Collectors.toList());
    }

    private String[] getPackage(AnnotationAttributes attributes, String key) {
        String[] packages = attributes.getStringArray(key);
        if (packages.length == 0) {
            packages = new String[]{};
        }
        return packages;
    }
}

