/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.spring.scan;

import com.huawei.fitframework.annotation.Genericable;
import com.huawei.fitframework.core.common.util.ClassScanner;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericableScanner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenericableScanner.class);
    private final ClassScanner classScanner;
    private Set<Class<?>> genericableClasses;

    public GenericableScanner(ClassScanner classScanner) {
        this.classScanner = (ClassScanner)Validation.notNull((Object)classScanner, (String)"Class scanner to scan genericables cannot be null.", (Object[])new Object[0]);
        this.classScanner.addClassDetectedObserver(this::onClassDetected);
    }

    public void scan() {
        this.genericableClasses = new HashSet();
        this.classScanner.scan();
    }

    protected void onClassDetected(String className) {
        Class<?> objectClass;
        try {
            objectClass = this.getClass().getClassLoader().loadClass(className);
        }
        catch (Throwable t) {
            log.warn("Fail to load class: [name={}]", (Object)className);
            log.debug(t.getClass().getName(), t);
            return;
        }
        String genericableId = GenericableScanner.identifyGenericable(objectClass);
        if (genericableId != null) {
            this.genericableClasses.add(objectClass);
        }
    }

    private static String identifyGenericable(Class<?> genericableClass) {
        Genericable annotation = genericableClass.getDeclaredAnnotation(Genericable.class);
        if (annotation == null) {
            return null;
        }
        return annotation.value();
    }

    public Set<Class<?>> getGenericableClasses() {
        if (this.genericableClasses == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.genericableClasses);
    }
}

