/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.distributed.deploy.bpm;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.dto.ActivityResult;
import com.huawei.yinglong.distributed.deploy.entity.NetworkInitActiveResult;
import com.huawei.yinglong.distributed.deploy.entity.request.NetworkInitParam;
import com.huawei.yinglong.distributed.deploy.util.ResultUtils;
import com.huawei.yinglong.distributed.entity.ResultStatus;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.drop.entity.task.entity.entity.TaskStatistics;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.QueryTaskStatistics;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.SubmitTask;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.MultiDeployTaskDetail;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.QueryTaskDetailParam;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.TaskParams;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.service.QueryTaskDetail;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.camunda.bpm.client.spring.SpringTopicSubscription;
import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.spring.boot.starter.ClientProperties;
import org.camunda.bpm.client.spring.event.SubscriptionInitializedEvent;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.client.task.ExternalTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.event.EventListener;

@Fitable
public class DistributedNetWorkInitExternalTask {
    private static final Logger log = LoggerFactory.getLogger(DistributedNetWorkInitExternalTask.class);
    private static final String BMC_IP_CONFIG_BY_INPUT = "bmc_ip_config_by_input";
    private static final List<String> BMC_INIT_STEPS = Collections.unmodifiableList(Arrays.asList("bmc_ip_config_by_input", "lit_indicator", "off_indicator"));
    private static final List<String> STORAGE_INIT_STEPS = Collections.unmodifiableList(Arrays.asList("init_node", "reboot_server"));
    protected String workerId;
    private final BpmContextService bpmContextService;
    @Fit(alias="queryTaskDetail\u7684\u5b9e\u73b0")
    private QueryTaskDetail queryTaskDetail;
    @Fit(alias="queryTaskStatistics\u7684\u5b9e\u73b0")
    private QueryTaskStatistics queryTaskStatistics;
    @Fit(alias="executeTask\u7684\u5b9e\u73b0")
    private SubmitTask submitTask;

    public DistributedNetWorkInitExternalTask(ClientProperties properties, BpmContextService bpmContextService) {
        this.workerId = properties.getWorkerId();
        this.bpmContextService = bpmContextService;
    }

    @ExternalTaskSubscription(value="queryBmcNetWorkInit", lockDuration=500L)
    @Bean
    public ExternalTaskHandler queryBmcConfigDetail() {
        return (externalTask, externalTaskService) -> {
            NetworkInitActiveResult result = this.queryNetWorkInitResult(externalTask.getExecutionId(), externalTask.getProcessInstanceId());
            this.bpmContextService.updateActivityResult(externalTask.getExecutionId(), (ActivityResult)result);
            this.updateBmcInitResult(externalTask, externalTaskService, result);
        };
    }

    @ExternalTaskSubscription(value="startStorageNetWorkInit", lockDuration=1000L)
    @Bean
    public ExternalTaskHandler startNetConfig() {
        return (externalTask, externalTaskService) -> {
            NetworkInitParam param = (NetworkInitParam)this.bpmContextService.getContext(externalTask.getExecutionId(), NetworkInitParam.class);
            param.setTaskId(String.join((CharSequence)"_", externalTask.getProcessInstanceId(), "default"));
            Response response = this.submitTask.process(this.buildStorageNetWorkInitParam(param));
            ResultUtils.updateResult(externalTask, externalTaskService, (Response<String>)response, this.bpmContextService);
        };
    }

    @ExternalTaskSubscription(value="queryNetConfigDetail", lockDuration=1000L)
    @Bean
    public ExternalTaskHandler queryNetConfigDetail() {
        return (externalTask, externalTaskService) -> {
            NetworkInitParam param = (NetworkInitParam)this.bpmContextService.getContext(externalTask.getExecutionId(), NetworkInitParam.class);
            param.setTaskId(String.join((CharSequence)"_", externalTask.getProcessInstanceId(), "default"));
            TaskStatistics statistics = (TaskStatistics)this.queryTaskStatistics.process(param.getTaskId(), String.join((CharSequence)",", STORAGE_INIT_STEPS)).getData();
            MultiDeployTaskDetail details = (MultiDeployTaskDetail)this.queryTaskDetail.process(this.buildStepQueryParams(param, STORAGE_INIT_STEPS)).getData();
            DistributedNetWorkInitExternalTask.resetDetails(details);
            NetworkInitActiveResult result = this.buildBmcNetWorkInitResult(statistics, details, param);
            this.bpmContextService.updateActivityResult(externalTask.getExecutionId(), (ActivityResult)result);
            this.updateActiveStatus(externalTask, externalTaskService, result);
        };
    }

    private void updateBmcInitResult(ExternalTask externalTask, ExternalTaskService externalTaskService, NetworkInitActiveResult result) {
        if (result.getStatus().isBmcIpFailed()) {
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
        }
    }

    private NetworkInitActiveResult queryNetWorkInitResult(String executionId, String processInstanceId) {
        NetworkInitParam param = (NetworkInitParam)this.bpmContextService.getContext(executionId, NetworkInitParam.class);
        param.setTaskId(String.join((CharSequence)"_", processInstanceId, "default"));
        TaskStatistics statistics = (TaskStatistics)this.queryTaskStatistics.process(param.getTaskId(), String.join((CharSequence)",", BMC_INIT_STEPS)).getData();
        MultiDeployTaskDetail details = (MultiDeployTaskDetail)this.queryTaskDetail.process(this.buildStepQueryParams(param, BMC_INIT_STEPS)).getData();
        return this.buildBmcNetWorkInitResult(statistics, details, param);
    }

    private void updateActiveStatus(ExternalTask externalTask, ExternalTaskService externalTaskService, NetworkInitActiveResult result) {
        ResultStatus status = result.getStatus();
        if (status.isSuccess()) {
            this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
            return;
        }
        if (status.isFailed()) {
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
            return;
        }
    }

    private NetworkInitActiveResult buildBmcNetWorkInitResult(TaskStatistics statistics, MultiDeployTaskDetail details, NetworkInitParam param) {
        return ((NetworkInitActiveResult.NetworkInitActiveResultBuilder)((Object)((NetworkInitActiveResult.NetworkInitActiveResultBuilder)((Object)((NetworkInitActiveResult.NetworkInitActiveResultBuilder)((Object)((NetworkInitActiveResult.NetworkInitActiveResultBuilder)((Object)NetworkInitActiveResult.builder().progress(details.getDetail().getProgress()))).overviews(details.getDeployTaskDetails()))).status(this.updateStatus(statistics, param)))).statistics(statistics))).build();
    }

    private static void resetDetails(MultiDeployTaskDetail details) {
        if (details.getDeployTaskDetails() == null) {
            return;
        }
        details.getDeployTaskDetails().forEach(deployTaskDetailVo -> deployTaskDetailVo.setStepTaskDetails(Collections.emptyList()));
    }

    private ResultStatus updateStatus(TaskStatistics statistics, NetworkInitParam param) {
        int totalNum = param.getDevIds().size();
        int finishedNum = statistics.getSuccessNum() + statistics.getFailedNum();
        if (finishedNum < totalNum) {
            return ResultStatus.RUNNING;
        }
        if (statistics.getSuccessNum() == totalNum) {
            return ResultStatus.SUCCESS;
        }
        if (statistics.getFailedNum() == totalNum) {
            return ResultStatus.FAILED;
        }
        return ResultStatus.PART_SUCCESS;
    }

    private TaskParams buildStorageNetWorkInitParam(NetworkInitParam param) {
        return TaskParams.builder().taskId(param.getTaskId()).subTaskIds(STORAGE_INIT_STEPS).deployVersion(param.getDeployVersion()).devIds(param.getDevIds()).build();
    }

    private QueryTaskDetailParam buildStepQueryParams(NetworkInitParam param, List<String> subTaskIds) {
        return QueryTaskDetailParam.builder().taskId(param.getTaskId()).subTaskIds(subTaskIds).build();
    }

    @EventListener(value={SubscriptionInitializedEvent.class})
    public void catchSubscriptionInitEvent(SubscriptionInitializedEvent event) {
        SpringTopicSubscription topicSubscription = event.getSource();
        if (!topicSubscription.isAutoOpen()) {
            topicSubscription.open();
            log.info("Subscription with topic name '{}' has been opened!", (Object)topicSubscription.getTopicName());
        }
    }
}

