/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.distributed.deploy.bpm;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.dto.ActivityResult;
import com.huawei.yinglong.bpm.dto.ProcessConfig;
import com.huawei.yinglong.distributed.deploy.entity.VersionCheckActiveResult;
import com.huawei.yinglong.distributed.deploy.entity.request.NetworkInitParam;
import com.huawei.yinglong.distributed.deploy.util.ResultUtils;
import com.huawei.yinglong.distributed.entity.ResultStatus;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.drop.entity.task.entity.entity.TaskStatistics;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.ExportWithScene;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.QueryTaskStatistics;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.SubmitTask;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.MultiDeployTaskDetail;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.QueryTaskDetailParam;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.TaskParams;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.service.QueryTaskDetail;
import java.util.Collections;
import java.util.List;
import org.camunda.bpm.client.spring.SpringTopicSubscription;
import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.spring.boot.starter.ClientProperties;
import org.camunda.bpm.client.spring.event.SubscriptionInitializedEvent;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.client.task.ExternalTaskService;
import org.camunda.bpm.engine.RuntimeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.event.EventListener;

@Fitable
public class VersionMappingCheckExternalTask {
    private static final Logger log = LoggerFactory.getLogger(VersionMappingCheckExternalTask.class);
    private static final String VERSION_CHECK_ITEM = "version_check";
    private static final List<String> VERSION_CHECK = Collections.singletonList("version_check");
    protected String workerId;
    private final BpmContextService bpmContextService;
    private final RuntimeService runtimeService;
    @Fit(alias="executeTask\u7684\u5b9e\u73b0")
    private SubmitTask submitTask;
    @Fit(alias="queryTaskDetail\u7684\u5b9e\u73b0")
    private QueryTaskDetail queryTaskDetail;
    @Fit(alias="queryTaskStatistics\u7684\u5b9e\u73b0")
    private QueryTaskStatistics queryTaskStatistics;
    @Fit(alias="\u90e8\u7f72\u52a9\u624b\u7684\u5b9e\u73b0")
    private ExportWithScene exportWithScene;

    public VersionMappingCheckExternalTask(ClientProperties properties, RuntimeService runtimeService, BpmContextService bpmContextService) {
        this.workerId = properties.getWorkerId();
        this.bpmContextService = bpmContextService;
        this.runtimeService = runtimeService;
    }

    @ExternalTaskSubscription(value="startVersionCheckDeploy")
    @Bean
    public ExternalTaskHandler startVersionCheckDeploy() {
        return (externalTask, externalTaskService) -> {
            String executionId = externalTask.getExecutionId();
            NetworkInitParam params = (NetworkInitParam)this.bpmContextService.getContext(executionId, NetworkInitParam.class);
            params.setTaskId(String.join((CharSequence)"_", externalTask.getProcessInstanceId(), "default"));
            Response response = this.submitTask.process(this.buildStartVersionCheckParam(params));
            ResultUtils.updateResult(externalTask, externalTaskService, (Response<String>)response, this.bpmContextService);
        };
    }

    @ExternalTaskSubscription(value="queryOverViewDeploy")
    @Bean
    public ExternalTaskHandler queryOverViewDeploy() {
        return (externalTask, externalTaskService) -> {
            NetworkInitParam param = (NetworkInitParam)this.bpmContextService.getContext(externalTask.getExecutionId(), NetworkInitParam.class);
            param.setTaskId(String.join((CharSequence)"_", externalTask.getProcessInstanceId(), "default"));
            TaskStatistics statistics = (TaskStatistics)this.queryTaskStatistics.process(param.getTaskId(), String.join((CharSequence)",", VERSION_CHECK_ITEM)).getData();
            MultiDeployTaskDetail details = (MultiDeployTaskDetail)this.queryTaskDetail.process(this.buildStepQueryParams(param)).getData();
            VersionCheckActiveResult result = this.buildBmcNetWorkInitResult(statistics, details, param);
            this.bpmContextService.updateActivityResult(externalTask.getExecutionId(), (ActivityResult)result);
            this.generateReportWhenFinish(externalTask.getExecutionId(), externalTask.getProcessInstanceId(), result);
            this.updateActiveStatus(externalTask, externalTaskService, result);
        };
    }

    private void generateReportWhenFinish(String executionId, String taskId, VersionCheckActiveResult result) {
        if (!result.getStatus().isFinished()) {
            return;
        }
        ProcessConfig processConfig = (ProcessConfig)this.runtimeService.getVariable(executionId, "context");
        Response exportRes = this.exportWithScene.process(taskId, processConfig.getReportDir(), "quality_check");
        log.info("export version check report result: {}", (Object)exportRes);
    }

    private TaskParams buildStartVersionCheckParam(NetworkInitParam param) {
        return TaskParams.builder().taskId(param.getTaskId()).subTaskIds(VERSION_CHECK).deployVersion(param.getDeployVersion()).devIds(param.getDevIds()).build();
    }

    private VersionCheckActiveResult buildBmcNetWorkInitResult(TaskStatistics statistics, MultiDeployTaskDetail details, NetworkInitParam param) {
        return ((VersionCheckActiveResult.VersionCheckActiveResultBuilder)((Object)((VersionCheckActiveResult.VersionCheckActiveResultBuilder)((Object)((VersionCheckActiveResult.VersionCheckActiveResultBuilder)((Object)((VersionCheckActiveResult.VersionCheckActiveResultBuilder)((Object)VersionCheckActiveResult.builder().progress(details.getDetail().getProgress()))).overviews(details.getDeployTaskDetails()))).status(this.updateStatus(statistics, param)))).statistics(statistics))).build();
    }

    private QueryTaskDetailParam buildStepQueryParams(NetworkInitParam param) {
        return QueryTaskDetailParam.builder().taskId(param.getTaskId()).subTaskIds(VERSION_CHECK).build();
    }

    private ResultStatus updateStatus(TaskStatistics statistics, NetworkInitParam param) {
        int totalNum = param.getDevIds().size();
        int finishedNum = statistics.getSuccessNum() + statistics.getFailedNum();
        if (finishedNum < totalNum) {
            return ResultStatus.RUNNING;
        }
        if (statistics.getSuccessNum() == totalNum) {
            return ResultStatus.SUCCESS;
        }
        if (statistics.getFailedNum() == totalNum) {
            return ResultStatus.FAILED;
        }
        return ResultStatus.PART_SUCCESS;
    }

    private void updateActiveStatus(ExternalTask externalTask, ExternalTaskService externalTaskService, VersionCheckActiveResult result) {
        ResultStatus status = result.getStatus();
        if (status.isSuccess()) {
            this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
            return;
        }
        if (status.isFailed()) {
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
        }
    }

    @EventListener(value={SubscriptionInitializedEvent.class})
    public void catchSubscriptionInitEvent(SubscriptionInitializedEvent event) {
        SpringTopicSubscription topicSubscription = event.getSource();
        if (!topicSubscription.isAutoOpen()) {
            topicSubscription.open();
            log.info("Subscription with topic name '{}' has been opened!", (Object)topicSubscription.getTopicName());
        }
    }
}

