/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.distributed.deploy.controller;

import com.huaiwei.yinglong.river.deploy.storage.distribution.deployhelper.entity.BiosPassword;
import com.huaiwei.yinglong.river.deploy.storage.distribution.deployhelper.entity.VerifyBiosPassword;
import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.broker.FitableNotFoundException;
import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.BpmEngineService;
import com.huawei.yinglong.bpm.dto.ProcessActivity;
import com.huawei.yinglong.bpm.dto.ProcessConfig;
import com.huawei.yinglong.bpm.dto.ProcessInstanceDto;
import com.huawei.yinglong.bpm.util.ResponseUtil;
import com.huawei.yinglong.distributed.context.UpdateConcurrentNumberContext;
import com.huawei.yinglong.distributed.deploy.entity.request.ExportReportParam;
import com.huawei.yinglong.distributed.deploy.entity.request.NetworkInitParam;
import com.huawei.yinglong.distributed.deploy.entity.request.ParseLldTemplateParams;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.ExportLldTemplate;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.UpdateConcurrentNumber;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.UpdateSelectNodes;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.AddOrModifySshNode;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.AddOrModifySshSubNode;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.DeleteNode;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.DeleteSubNode;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.DeployTaskDetailVo;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.ExportWithScene;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.GetSshProxyList;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.ModifyBmcIpParam;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.MultiDeployNodes;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.QueryDeployNode;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.QueryDetailParam;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.QueryTaskStatistics;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.SshProxyNodeFit;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.StartSsdpSearch;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.SubmitTask;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.ParseDetail;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.TaskParams;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.service.ExportReport;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.service.ModifyBmcIp;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.service.ParseLldTemplate;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.service.QueryTaskDetail;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.service.RetryItem;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.service.RetryTask;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.task.ModifyItemTaskStatus;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.task.QueryDeployNodeDetail;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.task.entity.ItemParams;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.task.entity.ModifyItemTaskStatusParams;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.RemoveServerByClusterId;
import com.huawei.yinglong.smartkit.base.util.ResourceUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/deploy"})
public class DistributedNetWorkInitController {
    private static final Logger log = LoggerFactory.getLogger(DistributedNetWorkInitController.class);
    @Fit(alias="\u90e8\u7f72\u52a9\u624b\u7684\u5b9e\u73b0")
    private UpdateSelectNodes updateSelectNodes;
    @Fit(alias="\u5de1\u68c0\u7684\u5b9e\u73b0")
    private RemoveServerByClusterId removeServerByClusterId;
    @Fit(alias="retryItem\u7684\u5b9e\u73b0")
    private RetryItem retryItem;
    @Fit(alias="retryTask\u7684\u5b9e\u73b0")
    private RetryTask retryTask;
    @Fit
    private SubmitTask submitTask;
    @Fit(alias="exportReport\u7684\u5b9e\u73b0")
    private ExportReport exportReport;
    @Fit(alias="queryDeployNode\u7684\u5b9e\u73b0")
    private QueryDeployNode queryDeployNode;
    @Fit(alias="queryTaskStatistics\u7684\u5b9e\u73b0")
    private QueryTaskStatistics queryTaskStatistics;
    @Fit(alias="modifyItemTaskStatus\u7684\u5b9e\u73b0")
    private ModifyItemTaskStatus ignoreItem;
    @Fit(alias="queryDeployNodeDetail\u7684\u5b9e\u73b0")
    private QueryDeployNodeDetail queryDeployNodeDetail;
    @Fit(alias="modifyBmcIp\u7684\u5b9e\u73b0")
    private ModifyBmcIp modifyBmcIp;
    @Fit(alias="parseLld\u7684\u5b9e\u73b0")
    private ParseLldTemplate parseLldTemplate;
    @Fit(alias="exportLldTemplate\u7684\u5b9e\u73b0")
    private ExportLldTemplate exportLldTemplate;
    @Fit(alias="queryTaskDetail\u7684\u5b9e\u73b0")
    private QueryTaskDetail queryTaskDetail;
    @Autowired
    private BpmEngineService bpmEngineService;
    @Fit(alias="\u90e8\u7f72\u52a9\u624b\u7684\u5b9e\u73b0")
    private StartSsdpSearch startSsdpSearch;
    @Fit(alias="\u90e8\u7f72\u52a9\u624b\u7684\u5b9e\u73b0")
    private ExportWithScene exportWithScene;
    @Fit(alias="addOrModifySSHNode\u7684\u5b9e\u73b0")
    private AddOrModifySshNode addOrModifySSHNode;
    @Fit(alias="addOrModifySshSubNode\u7684\u5b9e\u73b0")
    private AddOrModifySshSubNode addOrModifySshSubNode;
    @Fit(alias="deleteNode\u7684\u5b9e\u73b0")
    private DeleteNode deleteNode;
    @Fit(alias="deleteSubNode\u7684\u5b9e\u73b0")
    private DeleteSubNode deleteSubNode;
    @Fit(alias="getSshProxyList\u7684\u5b9e\u73b0")
    private GetSshProxyList getSshProxyList;
    @Fit(alias="updateConcurrentNumber\u7684\u5b9e\u73b0")
    private UpdateConcurrentNumber updateConcurrentNumber;
    @Fit(alias="verifyBiosPassword\u7684\u5b9e\u73b0")
    private VerifyBiosPassword verifyBiosPassword;
    @Autowired
    private BpmContextService bpmContextService;
    @Fit(alias="updateConcurrentNumber\u7684\u6570\u636e\u91c7\u96c6\u5b9e\u73b0")
    private UpdateConcurrentNumber updateCollectInfoConcurrentNumber;

    @PostMapping(value={"concurrentNumber"})
    public Response<String> updateConcurrentNumber(@RequestBody Map<String, Integer> concurrentNumberMap) {
        try {
            Response updateCollectInfoConcurrentNumberProcess = this.updateCollectInfoConcurrentNumber.process(concurrentNumberMap);
            if (ResponseUtil.isFailed((Response)updateCollectInfoConcurrentNumberProcess)) {
                return updateCollectInfoConcurrentNumberProcess;
            }
            Response updateConcurrentNumberProcess = this.updateConcurrentNumber.process(concurrentNumberMap);
            if (ResponseUtil.isFailed((Response)updateConcurrentNumberProcess)) {
                return updateConcurrentNumberProcess;
            }
            UpdateConcurrentNumberContext.getInstance().setUpdateConcurrentNumber(concurrentNumberMap.getOrDefault("concurrentNumber", 20).intValue());
            return updateConcurrentNumberProcess;
        }
        catch (FitableNotFoundException e) {
            log.error("The distributed subtool version does not match. Check whether the distributed plug-in version is 24.0.0.RC5 or later.");
            Response response = new Response();
            response.getResult().setCode(Integer.valueOf(1));
            response.getResult().setDescription(ResourceUtils.getString((String)"sub.tool.version.not.match"));
            return response;
        }
    }

    @PostMapping(value={"verifyBiosPwd"})
    public Response<String> verifyBiosPassword(@RequestBody BiosPassword biosPassword) {
        return this.verifyBiosPassword.process(biosPassword);
    }

    @GetMapping(value={"lldTemplate"})
    public Response<String> exportLldTemplate(String targetDir) {
        log.info("[network init] start to export lld template, targetDir : {}.", (Object)targetDir);
        Response response = this.exportLldTemplate.process(targetDir);
        log.info("[network init] start to export lld template, result : {}.", (Object)response);
        return response;
    }

    @PostMapping(value={"lldTemplate"})
    public Response<ParseDetail> parseLldTemplate(@RequestBody ParseLldTemplateParams params) {
        log.info("[network init] start to parse lld template, params : {}.", (Object)params);
        String taskId = params.getTaskId();
        boolean result = this.removeServerByClusterId.process(taskId.contains("_") ? taskId.split("_")[0] : taskId);
        log.info("[network init] try to remove server, task id : {}, result : {}.", (Object)taskId, (Object)result);
        Response response = this.parseLldTemplate.process(params.getTaskId(), params.getLldFilePath(), params.getScene());
        log.info("[network init] end to parse lld template, result : {}.", (Object)response);
        return response;
    }

    @GetMapping(value={"nodes"})
    public Response<MultiDeployNodes> queryDeployNode(String taskId) {
        return this.queryDeployNode.process(taskId);
    }

    @PostMapping(value={"bmcIp/{activeId}"})
    public Response<String> modifyBmcIp(@PathVariable(value="activeId") String activeId, @RequestBody ModifyBmcIpParam params) {
        log.info("[network init] start to modify bmc ip, activeId : {}, params : {}.", (Object)activeId, (Object)params);
        Response response = this.modifyBmcIp.process(params);
        this.notifyActiveInstanceActive(activeId);
        log.info("[network init] start to modify bmc ip, result : {}.", (Object)response);
        return response;
    }

    @PostMapping(value={"node/detail"})
    public Response<DeployTaskDetailVo> queryDeployDetail(@RequestBody QueryDetailParam param) {
        return this.queryDeployNodeDetail.process(param);
    }

    @PostMapping(value={"node/subTask/{activeId}"})
    public Response<String> submitTask(@PathVariable(value="activeId") String activeId, @RequestBody TaskParams params) {
        log.info("[network init] start to submit task, activeId : {}, params : {}.", (Object)activeId, (Object)params);
        Response response = this.submitTask.process(params);
        this.notifyActiveInstanceActive(activeId);
        log.info("[network init] end to submit task, result : {}.", (Object)response);
        return response;
    }

    @PostMapping(value={"node/subtask/retry/{activeId}"})
    public Response<String> retry(@PathVariable(value="activeId") String activeId, @RequestBody TaskParams params) {
        log.info("[network init] start to retry task, activeId : {}, params : {}.", (Object)activeId, (Object)params);
        Response response = this.retryTask.process(params);
        this.notifyActiveInstanceActive(activeId);
        log.info("[network init] end to retry task, result : {}.", (Object)response);
        return response;
    }

    @PostMapping(value={"node/item/retry/{activeId}"})
    public Response<String> retryItem(@PathVariable(value="activeId") String activeId, @RequestBody ItemParams params) {
        log.info("[network init] start to retry item, activeId : {}, params : {}.", (Object)activeId, (Object)params);
        Response response = this.retryItem.process(params);
        this.notifyActiveInstanceActive(activeId);
        log.info("[network init] end to retry task, result : {}.", (Object)response);
        return response;
    }

    private void notifyActiveInstanceActive(@PathVariable(value="activeId") String activeId) {
        try {
            ProcessActivity activity = this.bpmEngineService.querySingleActivityByInstanceId(activeId);
            if (this.bpmEngineService.canStartProcessInstance(activity.getProcessInstanceId())) {
                this.bpmEngineService.retryProcessActivity(activity);
            }
        }
        catch (Exception e) {
            log.error("notify active {} active failed.", (Object)activeId, (Object)e);
        }
    }

    @PostMapping(value={"node/item/status/{activeId}"})
    public Response<String> ignoreItem(@PathVariable(value="activeId") String activeId, @RequestBody ModifyItemTaskStatusParams param) {
        log.info("[network init] start to ignore item, activeId : {}, params : {}.", (Object)activeId, (Object)param);
        Response response = this.ignoreItem.process(param);
        this.notifyActiveInstanceActive(activeId);
        log.info("[network init] end to ignore item, result : {}.", (Object)response);
        return response;
    }

    @PostMapping(value={"report"})
    public Response<String> exportReport(@RequestBody ExportReportParam exportReportParam) {
        log.info("[network init] start to export report, params : {}.", (Object)exportReportParam);
        Response response = this.isBmcIpConfig(exportReportParam) ? this.exportWithScene.process(exportReportParam.getTaskId(), exportReportParam.getTargetDir(), "bmc_ip_config") : this.exportReport.process(exportReportParam.getTaskId(), exportReportParam.getTargetDir());
        log.info("[network init] end to export report, result : {}.", (Object)response);
        return response;
    }

    private boolean isBmcIpConfig(ExportReportParam exportReportParam) {
        ProcessInstanceDto processInstanceDto = this.bpmEngineService.queryProcessInstance(exportReportParam.getTaskId());
        Object processConfig = processInstanceDto.getProcessConfig();
        if (Objects.isNull(processConfig) || !(processConfig instanceof ProcessConfig)) {
            return false;
        }
        Object frontData = ((ProcessConfig)processConfig).getBusiness().get("dataForFront");
        if (Objects.isNull(frontData) || !(frontData instanceof Map)) {
            return false;
        }
        return "ibmc-config".equals(((Map)frontData).getOrDefault("id", "").toString());
    }

    @PostMapping(value={"/ssdp-search/start"})
    public Response<String> startSsdpSearch(@RequestBody TaskParams taskParams) {
        log.info("[network init] start to ssdp search, params : {}.", (Object)taskParams);
        Response response = this.startSsdpSearch.process(taskParams);
        log.info("[network init] end to ssdp search, result : {}.", (Object)response);
        return response;
    }

    @PostMapping(value={"/bmc/ip/config/{activeId}/{taskId}"})
    public Response<String> batchConfigBmcIp(@PathVariable(value="activeId") String activeId, @PathVariable(value="taskId") String taskId) {
        log.info("[network init] start to batch config bmc ip, activeId : {}, task id : {}.", (Object)activeId, (Object)taskId);
        TaskParams taskParams = this.buildParam(taskId);
        log.info("[network init] try to update select nodes, params : {}.", (Object)taskParams);
        this.updateSelectNodes.process(taskParams);
        Response response = this.submitTask.process(taskParams);
        this.notifyActiveInstanceActive(activeId);
        log.info("[network init] start to batch config bmc ip, result : {}.", (Object)response);
        return response;
    }

    private TaskParams buildParam(String taskId) {
        NetworkInitParam context = (NetworkInitParam)this.bpmContextService.getContext(taskId.split("_")[0], NetworkInitParam.class);
        TaskParams taskParams = new TaskParams();
        taskParams.setDevIds(context.getDevIds());
        taskParams.setTaskId(taskId);
        taskParams.setSubTaskIds(Collections.singletonList("bmc_ip_config_by_input"));
        taskParams.setDeployVersion("nfv.dedicated");
        return taskParams;
    }

    @PostMapping(value={"/ssh/node"})
    public Response<Void> addOrModifySSHNode(@RequestParam(value="nodeId") String nodeId, @RequestParam(value="name") String name) {
        log.info("[network init] start to add or modify ssh node, id : {}, name : {}.", (Object)nodeId, (Object)name);
        Response response = this.addOrModifySSHNode.process(nodeId, name);
        log.info("[network init] end to add or modify ssh node, result : {}.", (Object)response);
        return response;
    }

    @PutMapping(value={"/ssh/node"})
    public Response<Void> modifySSHNode(@RequestParam(value="nodeId") String nodeId, @RequestParam(value="name") String name) {
        log.info("[network init] start to modify ssh node, id : {}, name : {}.", (Object)nodeId, (Object)name);
        Response response = this.addOrModifySSHNode.process(nodeId, name);
        log.info("[network init] end to modify ssh node, result : {}.", (Object)response);
        return response;
    }

    @DeleteMapping(value={"/ssh/node"})
    public Response<Void> deleteNode(@RequestParam(value="nodeId") String nodeId) {
        log.info("[network init] start to delete ssh node, id : {}.", (Object)nodeId);
        Response response = this.deleteNode.process(nodeId);
        log.info("[network init] end to delete ssh node, result : {}.", (Object)response);
        return response;
    }

    @PostMapping(value={"/ssh/subNode"})
    public Response<Void> addSshSubNode(@RequestBody SshProxyNodeFit sshProxyNode) {
        log.info("[network init] start to add ssh sub node, params : {}.", (Object)sshProxyNode);
        Response response = this.addOrModifySshSubNode.process(sshProxyNode);
        log.info("[network init] end to add ssh sub node, result : {}.", (Object)response);
        return response;
    }

    @PutMapping(value={"/ssh/subNode"})
    public Response<Void> modifySshSubNode(@RequestBody SshProxyNodeFit sshProxyNode) {
        log.info("[network init] start to modify ssh sub node, params : {}.", (Object)sshProxyNode);
        Response response = this.addOrModifySshSubNode.process(sshProxyNode);
        log.info("[network init] end to modify ssh sub node, result : {}.", (Object)response);
        return response;
    }

    @DeleteMapping(value={"/ssh/subNode"})
    public Response<Void> deleteSubNode(@RequestParam(value="nodeId") String nodeId, @RequestParam(value="subNodeId") String subNodeId) {
        log.info("[network init] start to delete ssh sub node, id : {}, sub id : {}.", (Object)nodeId, (Object)subNodeId);
        Response response = this.deleteSubNode.process(nodeId, subNodeId);
        log.info("[network init] end to delete ssh sub node, result : {}.", (Object)response);
        return response;
    }

    @GetMapping(value={"/ssh/node"})
    public Response<List<SshProxyNodeFit>> getSSHProxyList() {
        return this.getSshProxyList.process();
    }
}

