/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.distributed.deploy.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huawei.fitframework.annotation.Fit;
import com.huawei.yinglong.distributed.deploy.entity.ServerDto;
import com.huawei.yinglong.distributed.deploy.entity.request.ParseLldTemplateParams;
import com.huawei.yinglong.distributed.deploy.entity.request.ServerAuthParam;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.ExportTemplate;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.QueryCpuArchitecture;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.SystemInstallVerify;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.CpuArchitectureParam;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.InstallVerifyParam;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.QueryMappingVersion;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.MultiMappingVersions;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.ParseDetail;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.service.ParseLldTemplate;
import com.huawei.yinglong.river.devicemanager.storage.distribution.auth.BatchAuthBmc;
import com.huawei.yinglong.river.devicemanager.storage.distribution.auth.BatchAuthOs;
import com.huawei.yinglong.river.devicemanager.storage.distribution.auth.BmcConnectivityTest;
import com.huawei.yinglong.river.devicemanager.storage.distribution.auth.OsConnectivityTest;
import com.huawei.yinglong.river.devicemanager.storage.distribution.auth.entity.ConnectivityTestParam;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.QueryMultiServer;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.RemoveServer;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.RemoveServerByClusterId;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.entity.MultiServer;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.entity.Server;
import com.huawei.yinglong.river.system.storage.distribution.GetDeployToolsTimeZone;
import com.huawei.yinglong.smartkit.base.util.ResponseUtil;
import java.util.List;
import javax.ws.rs.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/server"})
public class DistributedServerController {
    private static final Logger log = LoggerFactory.getLogger(DistributedServerController.class);
    @Fit(alias="\u5de1\u68c0\u7684\u5b9e\u73b0")
    private RemoveServerByClusterId removeServerByClusterId;
    @Fit
    private ExportTemplate exportTemplate;
    @Fit
    private BmcConnectivityTest bmcConnectivityTest;
    @Fit
    private OsConnectivityTest osConnectivityTest;
    @Fit
    private BatchAuthOs batchAuthOs;
    @Fit
    private BatchAuthBmc batchAuthBmc;
    @Fit
    private RemoveServer removeServer;
    @Fit
    private QueryMultiServer queryMultiServer;
    @Fit(alias="parseLld\u7684\u5b9e\u73b0")
    private ParseLldTemplate parseLldTemplate;
    @Fit
    private QueryMappingVersion queryMappingVersion;
    @Fit
    private GetDeployToolsTimeZone getDeployToolsTimeZone;
    @Fit
    private QueryCpuArchitecture queryCpuArchitecture;
    @Fit
    private SystemInstallVerify systemInstallVerify;

    @PostMapping(value={"template"})
    public Response<ParseDetail> parseLldTemplate(@RequestBody ParseLldTemplateParams params) {
        log.info("[distributed server] start to parse lld template, params : {}.", (Object)params);
        String taskId = params.getTaskId();
        MultiServer multiServer = this.queryMultiServer.process(taskId.contains("_") ? taskId.split("_")[0] : taskId);
        log.info("[distributed server] try to query multi server, result : {}.", (Object)multiServer);
        multiServer.getServer().stream().map(Server::getUid).forEach(arg_0 -> ((RemoveServer)this.removeServer).process(arg_0));
        boolean result = this.removeServerByClusterId.process(taskId);
        log.info("[distributed server] try to remove server by cluster id, task id : {}, result : {}.", (Object)taskId, (Object)result);
        Response response = this.parseLldTemplate.process(params.getTaskId(), params.getLldFilePath(), params.getScene());
        log.info("[distributed server] end to parse lld template, params : {}.", (Object)response);
        return response;
    }

    @GetMapping(value={"template"})
    public Response<String> getServerTemplate(String targetDir, String scene) {
        log.info("[distributed server] start to get server template, targetDir : {}, scene : {}.", (Object)targetDir, (Object)scene);
        Response response = this.exportTemplate.process(targetDir, scene);
        log.info("[distributed server] end to get server template, result : {}.", (Object)response);
        return response;
    }

    @GetMapping
    public Response<List<ServerDto>> queryServer(String taskId) {
        return ResponseUtil.success(ServerDto.buildServerDto(this.queryMultiServer.process(taskId).getServer()));
    }

    @PostMapping(value={"bmc/connectivity"})
    public Response<String> batchAuthBmc(@RequestBody ServerAuthParam params) {
        log.info("[distributed server] start to batch auth bmc, params : {}.", (Object)params);
        Response response = this.bmcConnectivityTest.process(ConnectivityTestParam.builder().uids(params.getUids()).port(Integer.valueOf(443)).build());
        log.info("[distributed server] end to batch auth bmc, result : {}.", (Object)response);
        return response;
    }

    @PostMapping(value={"os/connectivity"})
    public Response<String> batchAuthOs(@RequestBody ConnectivityTestParam params) {
        log.info("[distributed server] start to batch auth os, params : {}.", (Object)params);
        Response response = this.osConnectivityTest.process(ConnectivityTestParam.builder().uids(params.getUids()).port(Integer.valueOf(22)).build());
        log.info("[distributed server] end to batch auth os, result : {}.", (Object)response);
        return response;
    }

    @GetMapping(value={"queryMappingVersion"})
    public Response<MultiMappingVersions> queryMappingVersion(@QueryParam(value="taskId") String taskId, @QueryParam(value="floatIp") String floatIp, @QueryParam(value="devType") String devType) {
        return this.queryMappingVersion.process(taskId, floatIp, devType);
    }

    @GetMapping(value={"/timezone"})
    public Response<JSONObject> getDeployToolsTimeZone(String scene) {
        Response process = this.getDeployToolsTimeZone.process(scene);
        if (!ResponseUtil.isSuccess((Response)process)) {
            return ResponseUtil.failed((String)((String)process.getData()), (String)"");
        }
        return ResponseUtil.success((Object)JSON.parseObject((String)((String)process.getData())));
    }

    @PostMapping(value={"/cpu/architecture"})
    public Response<String> queryCpuArchitecture(@RequestBody CpuArchitectureParam param) {
        return this.queryCpuArchitecture.process(param);
    }

    @PostMapping(value={"/system/verify"})
    public Response<String> systemInstallVerify(@RequestBody InstallVerifyParam param) {
        log.info("[distributed server] start to system install verify, params : {}.", (Object)param);
        Response response = this.systemInstallVerify.process(param);
        log.info("[distributed server] end to system install verify, result : {}.", (Object)response);
        return response;
    }
}

