/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.distributed.deploy.entity;

import com.huawei.yinglong.river.devicemanager.storage.distribution.auth.entity.AuthStatus;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.entity.Server;
import java.util.List;
import java.util.stream.Collectors;

public class ServerDto {
    private String id;
    private String serverType;
    private String serverName;
    private String bmcIp;
    private String bmcUserName;
    private AuthStatus bmcAuthStatus;
    private String osIp;
    private String osUserName;
    private String cpuArchitecture;
    private String sn;
    private AuthStatus osAuthStatus;

    public static ServerDto buildServerDto(Server serverDo) {
        return ServerDto.builder().id(serverDo.getUid()).serverType(serverDo.getModel()).serverName(serverDo.getProductName()).bmcIp(serverDo.getBmcIp()).bmcUserName(serverDo.getLoginUser() == null ? "" : serverDo.getLoginUser().getName()).bmcAuthStatus(serverDo.getBmcAuthStatus()).osIp(serverDo.getOsIp()).osUserName(serverDo.getOsUser() == null ? "" : serverDo.getOsUser().getName()).osAuthStatus(serverDo.getOsAuthStatus()).cpuArchitecture(serverDo.getCpuArchitecture()).sn(serverDo.getSn()).build();
    }

    public static List<ServerDto> buildServerDto(List<Server> serverDos) {
        return serverDos.stream().map(ServerDto::buildServerDto).collect(Collectors.toList());
    }

    ServerDto(String id, String serverType, String serverName, String bmcIp, String bmcUserName, AuthStatus bmcAuthStatus, String osIp, String osUserName, String cpuArchitecture, String sn, AuthStatus osAuthStatus) {
        this.id = id;
        this.serverType = serverType;
        this.serverName = serverName;
        this.bmcIp = bmcIp;
        this.bmcUserName = bmcUserName;
        this.bmcAuthStatus = bmcAuthStatus;
        this.osIp = osIp;
        this.osUserName = osUserName;
        this.cpuArchitecture = cpuArchitecture;
        this.sn = sn;
        this.osAuthStatus = osAuthStatus;
    }

    public static ServerDtoBuilder builder() {
        return new ServerDtoBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getServerType() {
        return this.serverType;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getBmcIp() {
        return this.bmcIp;
    }

    public String getBmcUserName() {
        return this.bmcUserName;
    }

    public AuthStatus getBmcAuthStatus() {
        return this.bmcAuthStatus;
    }

    public String getOsIp() {
        return this.osIp;
    }

    public String getOsUserName() {
        return this.osUserName;
    }

    public String getCpuArchitecture() {
        return this.cpuArchitecture;
    }

    public String getSn() {
        return this.sn;
    }

    public AuthStatus getOsAuthStatus() {
        return this.osAuthStatus;
    }

    public static class ServerDtoBuilder {
        private String id;
        private String serverType;
        private String serverName;
        private String bmcIp;
        private String bmcUserName;
        private AuthStatus bmcAuthStatus;
        private String osIp;
        private String osUserName;
        private String cpuArchitecture;
        private String sn;
        private AuthStatus osAuthStatus;

        ServerDtoBuilder() {
        }

        public ServerDtoBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ServerDtoBuilder serverType(String serverType) {
            this.serverType = serverType;
            return this;
        }

        public ServerDtoBuilder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public ServerDtoBuilder bmcIp(String bmcIp) {
            this.bmcIp = bmcIp;
            return this;
        }

        public ServerDtoBuilder bmcUserName(String bmcUserName) {
            this.bmcUserName = bmcUserName;
            return this;
        }

        public ServerDtoBuilder bmcAuthStatus(AuthStatus bmcAuthStatus) {
            this.bmcAuthStatus = bmcAuthStatus;
            return this;
        }

        public ServerDtoBuilder osIp(String osIp) {
            this.osIp = osIp;
            return this;
        }

        public ServerDtoBuilder osUserName(String osUserName) {
            this.osUserName = osUserName;
            return this;
        }

        public ServerDtoBuilder cpuArchitecture(String cpuArchitecture) {
            this.cpuArchitecture = cpuArchitecture;
            return this;
        }

        public ServerDtoBuilder sn(String sn) {
            this.sn = sn;
            return this;
        }

        public ServerDtoBuilder osAuthStatus(AuthStatus osAuthStatus) {
            this.osAuthStatus = osAuthStatus;
            return this;
        }

        public ServerDto build() {
            return new ServerDto(this.id, this.serverType, this.serverName, this.bmcIp, this.bmcUserName, this.bmcAuthStatus, this.osIp, this.osUserName, this.cpuArchitecture, this.sn, this.osAuthStatus);
        }

        public String toString() {
            return "ServerDto.ServerDtoBuilder(id=" + this.id + ", serverType=" + this.serverType + ", serverName=" + this.serverName + ", bmcIp=" + this.bmcIp + ", bmcUserName=" + this.bmcUserName + ", bmcAuthStatus=" + this.bmcAuthStatus + ", osIp=" + this.osIp + ", osUserName=" + this.osUserName + ", cpuArchitecture=" + this.cpuArchitecture + ", sn=" + this.sn + ", osAuthStatus=" + this.osAuthStatus + ")";
        }
    }
}

