/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.distributed.upgrade.bpm;

import com.alibaba.fastjson.JSON;
import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.distributed.context.UpdateConcurrentNumberContext;
import com.huawei.yinglong.distributed.upgrade.entity.UpgradeParams;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.QueryServer;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.entity.Server;
import com.huawei.yinglong.river.upgrade.storage.distributed.fireware.entity.UpgradeToolParams;
import com.huawei.yinglong.smartkit.base.util.SystemEnvUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.spring.boot.starter.ClientProperties;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.engine.RuntimeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;

@Fitable
public class UpgradeExternalTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeExternalTask.class);
    private static final String UPGRADE_TOOL_DIR = "DistributedFWUpgrade";
    private static final String START_BAT = "startTool.bat";
    @Fit
    private QueryServer queryServer;
    private String workerId;
    private final RuntimeService runtimeService;
    private final BpmContextService bpmContextService;

    public UpgradeExternalTask(ClientProperties properties, RuntimeService runtimeService, BpmContextService bpmContextService) {
        this.workerId = properties.getWorkerId();
        this.runtimeService = runtimeService;
        this.bpmContextService = bpmContextService;
    }

    @ExternalTaskSubscription(value="startUpgradeTool")
    @Bean
    public ExternalTaskHandler startUpgradeTool() {
        return (externalTask, externalTaskService) -> {
            UpgradeParams params = this.bpmContextService.getContext(externalTask.getExecutionId(), UpgradeParams.class);
            params.setTaskId(externalTask.getProcessInstanceId());
            try {
                List<Server> servers = params.getUids().stream().map(arg_0 -> ((QueryServer)this.queryServer).process(arg_0)).collect(Collectors.toList());
                UpgradeExternalTask.startTool(UpgradeExternalTask.writeServersInfo(servers, params.getUpgradeType()));
                this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
            }
            catch (Exception e) {
                log.error("start upgrade tool failed.", (Throwable)e);
                this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
            }
        };
    }

    @ExternalTaskSubscription(value="loopUpgradeTool", lockDuration=1000L)
    @Bean
    public ExternalTaskHandler loopUpgradeTool() {
        return (externalTask, externalTaskService) -> {
            File runningFlag = new File(UpgradeExternalTask.getUpgradeToolDirFile(), "runningFlag");
            try (FileOutputStream fos = new FileOutputStream(runningFlag);
                 FileLock fileLock = fos.getChannel().tryLock();){
                if (fileLock != null) {
                    this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
                    FileUtils.cleanDirectory((File)UpgradeExternalTask.getServerInfoDir());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        };
    }

    private static File writeServersInfo(List<Server> servers, String upgradeType) throws IOException {
        File serverInfoDir = UpgradeExternalTask.getServerInfoDir();
        serverInfoDir.mkdirs();
        File serverInfoFile = new File(serverInfoDir, "serverInfo");
        UpgradeToolParams params = UpgradeToolParams.builder().servers(servers).upgradeType(upgradeType).build();
        FileUtils.cleanDirectory((File)serverInfoDir);
        String data = JSON.toJSONString((Object)params);
        UpgradeExternalTask.writeFile(new File(serverInfoDir, "serverInfo"), data);
        return serverInfoFile;
    }

    @NonNull
    private static File getServerInfoDir() {
        return Paths.get(SystemEnvUtil.getDefaultUserDir(), "temp", "upgrade").toFile();
    }

    private static void writeFile(File targetFile, String data) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(targetFile);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            bos.write(data.getBytes(StandardCharsets.UTF_8));
            bos.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startTool(File devInfoFile) throws IOException, InterruptedException {
        File batFile = null;
        try {
            File upgradeToolFile = UpgradeExternalTask.getUpgradeToolDirFile();
            String batData = UpgradeExternalTask.buildStartToolData(devInfoFile, upgradeToolFile);
            batFile = new File(devInfoFile.getParentFile(), START_BAT);
            UpgradeExternalTask.writeFile(batFile, batData);
            File jreDir = new File(new File(SystemEnvUtil.getDefaultUserDir()).getParentFile().getParentFile(), "jre");
            String jreCmd = UpgradeExternalTask.getPathInCmd(new File(jreDir, "bin" + File.separator + "java.exe").getCanonicalPath());
            String executorCmd = UpgradeExternalTask.getPathInCmd(UpgradeExternalTask.getExecutorFile().getCanonicalPath());
            String startToolCmd = UpgradeExternalTask.getPathInCmd(batFile.getCanonicalPath());
            String cmd = "CMD /C " + jreCmd + " -jar " + executorCmd + " " + startToolCmd;
            Process process = Runtime.getRuntime().exec(cmd);
            do {
                Thread.sleep(1000L);
                UpgradeExternalTask.refreshOutput(process.getInputStream());
            } while (process.isAlive());
            Thread.sleep(10000L);
        }
        catch (Throwable throwable) {
            if (Objects.nonNull(batFile)) {
                FileUtils.delete(batFile);
            }
            throw throwable;
        }
        if (Objects.nonNull(batFile)) {
            FileUtils.delete((File)batFile);
        }
    }

    @NonNull
    private static File getExecutorFile() {
        File executor = new File(SystemEnvUtil.getDefaultUserDir(), "lib" + File.separator + "executor.jar");
        if (executor.exists()) {
            return executor;
        }
        return new File(SystemEnvUtil.getDefaultUserDir(), "lib" + File.separator + "executor-1.0-SNAPSHOT.jar");
    }

    @NonNull
    private static File getUpgradeToolDirFile() {
        return new File(new File(SystemEnvUtil.getDefaultUserDir()).getParent(), UPGRADE_TOOL_DIR);
    }

    @NonNull
    private static String buildStartToolData(File devInfoFile, File upgradeToolPath) throws IOException {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("language", SystemEnvUtil.getLanguage().toString());
        env.put("concurrentNumber", String.valueOf(UpdateConcurrentNumberContext.getInstance().getUpdateConcurrentNumber()));
        env.put("runMode", "test");
        env.put("framework.scene", "yinglong");
        env.put("deviceInfo", devInfoFile.getCanonicalPath());
        env.put("jsonScene", "{\"mainScene\":\"Upgrade\",\"subScene\":\"Upgrade_FSFW\",\"field\":\"Storage\",\"stepID\":\"FwUpgrade\",\"stepTitleEn\":\"Distributed Storage Firmware Upgrade\"}");
        env.put("jsonSceneArgsList", "{\"toolDescription\":\"Fusion_Strg_Svr_Upgrade\"}");
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("cd \"" + upgradeToolPath + "\"");
        cmds.addAll(env.entrySet().stream().map(keyValue -> "set " + (String)keyValue.getKey() + "=" + (String)keyValue.getValue()).collect(Collectors.toList()));
        cmds.add("start.exe");
        return String.join((CharSequence)"\r\n", cmds);
    }

    private static String getPathInCmd(String path) {
        return path.replace(" ", "\" \"");
    }

    private static void refreshOutput(InputStream is) throws IOException {
        int len;
        if (is == null) {
            return;
        }
        while ((len = is.available()) > 0) {
            byte[] bs = new byte[len];
            int bSize = is.read(bs);
            String outputStr = new String(bs, 0, bSize, "GBK");
            log.info("execute result : {}", (Object)outputStr);
        }
    }
}

