/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.serialization;

import com.huawei.fitframework.serialization.SerializationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public interface ByteSerializer<T> {
    public void serialize(T var1, OutputStream var2) throws IOException;

    default public byte[] serialize2Bytes(T value) {
        return ByteSerializer.serialize2Bytes(this, value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> byte[] serialize2Bytes(ByteSerializer<T> serializer, T value) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            serializer.serialize(value, out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new SerializationException("Fail to serialize object with serializer: " + e.getMessage(), e);
        }
    }

    public T deserialize(InputStream var1) throws IOException;

    default public T deserialize(byte[] value) {
        return ByteSerializer.deserialize(this, value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T deserialize(ByteSerializer<T> serializer, byte[] value) {
        try (ByteArrayInputStream in = new ByteArrayInputStream(value);){
            T t = serializer.deserialize(in);
            return t;
        }
        catch (IOException e) {
            throw new SerializationException("Fail to deserialize object from bytes: " + e.getMessage(), e);
        }
    }
}

