/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.log.support;

import com.huawei.fitframework.core.common.util.FileUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.log.LogConfigurator;
import com.huawei.fitframework.log.exception.LogConfigurationException;
import com.huawei.fitframework.runtime.SystemDirectories;
import com.huawei.fitframework.system.SystemClassLoaderContainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.spi.LoggerContext;

public class Log4j2Configurator
implements LogConfigurator {
    private static final String LOG_CONF_PREFIX = "log4j2.";
    private static final String FRAMEWORK_LOG_CON_PREFIX = "log4j2";
    private static final String SYSTEM_PROPERTY_DEBUG_ENABLED = "debug.enabled";
    private static final String LOG4J2_INFO_CONFIG = "log4j2-info.xml";
    private static final String LOG4J2_DEBUG_CONFIG = "log4j2-debug.xml";

    @Override
    public void configure(String filePath) {
        Log4j2Configurator.configure0(filePath);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> LogManager.shutdown((LoggerContext)LogManager.getContext())));
    }

    private static void configure0(String filePath) {
        if (StringUtils.isNotBlank((String)filePath) && Log4j2Configurator.configureLogFile(new File(filePath))) {
            return;
        }
        if (Log4j2Configurator.configureFile0(SystemDirectories.framework().conf(), LOG_CONF_PREFIX)) {
            return;
        }
        Log4j2Configurator.configureResource();
    }

    private static boolean configureLogFile(File file) {
        if (!file.exists()) {
            throw new LogConfigurationException(StringUtils.format((String)"Log config file is not found. [fileName = {0}]", (Object[])new Object[]{file.getName()}));
        }
        if (!file.isFile()) {
            throw new LogConfigurationException(StringUtils.format((String)"Log Config file must be a file. [filePath = {0}]", (Object[])new Object[]{file.getPath()}));
        }
        return Log4j2Configurator.configureFile0(file, FRAMEWORK_LOG_CON_PREFIX);
    }

    private static boolean configureFile0(File file, String filePrefix) {
        return FileUtils.traverse((File)file).filter(File::isFile).filter(logFile -> Log4j2Configurator.isLogConfig(logFile, filePrefix)).min(Comparator.comparingInt(FileUtils::depth).thenComparing(File::getName)).map(Log4j2Configurator::configureFile).orElse(false);
    }

    private static boolean isLogConfig(File file, String filePrefix) {
        return file.getName().startsWith(filePrefix);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean configureFile(File file) {
        if (file == null) {
            return false;
        }
        try (FileInputStream in = new FileInputStream(file);){
            Log4j2Configurator.configure(in);
            boolean bl = true;
            return bl;
        }
        catch (LogConfigurationException | IOException ignore) {
            return false;
        }
    }

    private static void configureResource() {
        String log4j2Xml = Boolean.getBoolean(SYSTEM_PROPERTY_DEBUG_ENABLED) ? LOG4J2_DEBUG_CONFIG : LOG4J2_INFO_CONFIG;
        try (InputStream in = Log4j2Configurator.class.getClassLoader().getResourceAsStream(log4j2Xml);){
            Log4j2Configurator.configure(in);
        }
        catch (IOException e) {
            throw new ConfigurationException(StringUtils.format((String)"Fail to configure log for application by resource. [resourceName={0}]", (Object[])new Object[]{log4j2Xml}), (Throwable)e);
        }
    }

    private static void configure(InputStream in) {
        ConfigurationSource source;
        Validation.notNull((Object)in, () -> new LogConfigurationException("No input stream configuration."));
        try {
            source = new ConfigurationSource(in);
        }
        catch (IOException e) {
            throw new LogConfigurationException("Fail to configure log for application by input stream.", e);
        }
        Configurator.initialize((ClassLoader)SystemClassLoaderContainer.getSharedClassLoader(), (ConfigurationSource)source);
    }
}

