/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.runtime.support;

import com.huawei.fitframework.core.common.util.IoUtils;
import com.huawei.fitframework.core.common.util.LazyLoader;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.runtime.FitFrameworkVersion;
import java.util.Optional;
import java.util.Properties;

public class DefaultFitFrameworkVersion
implements FitFrameworkVersion {
    private static final String POM_PROPERTIES_PATH = "//META-INF//maven//{0}//{1}//pom.properties";
    private static final String VERSION_KEY = "version";
    private final LazyLoader<String> versionStringLoader = new LazyLoader(() -> this.parseVersionString(groupId, artifactId).orElseThrow(() -> new IllegalArgumentException("Fail to get fit framework version.")));

    public DefaultFitFrameworkVersion(String groupId, String artifactId) {
    }

    @Override
    public String getVersionString() {
        return (String)this.versionStringLoader.get();
    }

    private Optional<String> parseVersionString(String groupId, String artifactId) {
        String pomPropertiesPath = StringUtils.format((String)POM_PROPERTIES_PATH, (Object[])new Object[]{groupId, artifactId});
        Properties properties = IoUtils.properties(DefaultFitFrameworkVersion.class, (String)pomPropertiesPath);
        return Optional.ofNullable(properties.getProperty(VERSION_KEY));
    }
}

