#!/usr/bin/python
# -*- coding: utf-8 -*-

import subprocess
import logging
import json
import time

ret = subprocess.Popen('mkdir ../log/', shell=True)
ret.wait()
ret = subprocess.Popen('mkdir ../result/', shell=True)
ret.wait()
logger = logging.Logger("first_logger")
my_handler = logging.FileHandler('../log/check_network_adapter.log')
my_handler.setLevel(logging.INFO)
my_format = logging.Formatter("%(asctime)s %(message)s line:%(lineno)d")
my_handler.setFormatter(my_format)
logger.addHandler(my_handler)

ret_list = []


def network_adapter_check():
    logger.info('Start to check whether the port is connected.')
    with open('../config/network_config.json', 'r') as f:
        config_list = json.load(f)

    port_names = []
    for i in config_list['network_config']:
        if i["port_name"] not in port_names:
            port_names.append(i["port_name"])

    not_link_ports = []
    for port_name in port_names:
        cmd = "ethtool {}".format(port_name)
        ret_list.append(cmd)
        ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
        ret.wait()
        info = str(ret.stdout.read()).replace("b'", '')[:-1]
        ret_list.append(info)
        if 'Link detected: yes' in info:
            logger.info("The port({}) is connected".format(port_name))
        else:
            logger.info("The port({}) is not connected".format(port_name))
            not_link_ports.append(port_name)
    if len(not_link_ports) == 1:
        message = '{} is not connected'.format(not_link_ports[0])
        ret_list.append(message)
        return 0, 'port is not connected'
    elif len(not_link_ports) > 1:
        not_link_ports = ','.join(not_link_ports)
        message = '{} are not connected'.format(not_link_ports)
        ret_list.append(message)
        return 0, 'port is not connected'


    logger.info("Start checking network adapter compatibility.")
    mellanox = ['MCX4121A-ACAT', 'MCX456A-ECAT', 'MCX512A-ACAT']
    cmd = 'lspci |grep Mellanox'
    ret_list.append(cmd)
    ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
    ret.wait()
    info = str(ret.stdout.read()).replace("b'", '')[:-1]
    ret_list.append(info)
    logger.info('Querying the Bus Information of NIC: {}'.format(info))
    ret1 = info.split("\\n" if "\\n" in info else "\n")
    tag = 'fail'
    for i in range(len(ret1)):
        if i == 0:
            bus = ret1[i].split(' ')[0][2:]
        else:
            bus = ret1[i].split(' ')[0]
        if len(bus) > 6:
            cmd = 'lspci -vv -s {} | grep "Part number"'.format(bus)
            ret_list.append(cmd)
            ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
            ret.wait()
            info = str(ret.stdout.read()).replace("b'", '')[:-1]
            ret_list.append(info)
            logger.info('query-{}-NIC type: {}'.format(bus, info))
        for j in mellanox:
            if j in info:
                tag = 'pass'
                logger.info('Check network card compatibility: pass')
                break
    if tag == 'fail':
        logger.info('Check network card compatibility: not pass')
        status = 0
        return status, 'NIC check error'
    status = 1
    return status, None


start_time = time.localtime(time.time())
start_time = time.strftime("%Y-%m-%d %H:%M:%S", start_time)

status_code, error_code = network_adapter_check()

end_time = time.localtime(time.time())
end_time = time.strftime("%Y-%m-%d %H:%M:%S", end_time)
res = {
    'config_item': 'check_network_adapter', 'start_time': start_time, 'end_time': end_time,
    'status': status_code, 'error_code': error_code, "origin_info": '\n'.join(ret_list)
}
res = str(json.dumps(res))
with open('../result/check_network_adapter_result.json', 'w') as f:
    f.write(res)
print('Execution completed')
