#!/usr/bin/python
# -*- coding: utf-8 -*-

import subprocess
import logging
import json
import time

logger = logging.Logger("first_logger")
my_handler = logging.FileHandler('../log/check_nvme_cli.log')
my_handler.setLevel(logging.INFO)
my_format = logging.Formatter("%(asctime)s %(message)s line:%(lineno)d")
my_handler.setFormatter(my_format)
logger.addHandler(my_handler)

ret_list = []

PASS = 1
NOT_PASS = 0


def nvme_cli_check():
    logger.info('start check nvme_cli')
    cmd = 'rpm -qa |grep nvme'
    ret_list.append(cmd)
    ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
    ret.wait()
    info = str(ret.stdout.read()).replace("b'", '')[:-1]
    ret_list.append(info)
    logger.info('check nvme-cli tool: {}'.format(info))
    if 'nvme-cli' in info:
        logger.info('check nvme-cli tool:pass')
    else:
        logger.info('check nvme-cli tool:not pass')
        status = NOT_PASS
        return status, 'nvme-cli check error'
    status = PASS
    return status, None


start_time = time.localtime(time.time())
start_time = time.strftime("%Y-%m-%d %H:%M:%S", start_time)

status_code, error_code = nvme_cli_check()

end_time = time.localtime(time.time())
end_time = time.strftime("%Y-%m-%d %H:%M:%S", end_time)
res = {'config_item': 'check_nvme_cli', 'start_time': start_time, 'end_time': end_time,
       'status': status_code, 'error_code': error_code, "origin_info": '\n'.join(ret_list)}
res = str(json.dumps(res))
with open('../result/check_nvme_cli_result.json', 'w') as f:
    f.write(res)
print('Execution completed')
