#!/usr/bin/python
# -*- coding: utf-8 -*-

import subprocess
import logging
import json
import time

logger = logging.Logger("first_logger")
my_handler = logging.FileHandler('../log/check_oceanstor_nof.log')
my_handler.setLevel(logging.INFO)
my_format = logging.Formatter("%(asctime)s %(message)s line:%(lineno)d")
my_handler.setFormatter(my_format)
logger.addHandler(my_handler)

ret_list = []


def oceanstor_nof_enabler_check():
    logger.info('Start check OceanStor_NOF_Enabler')
    cmd = 'cat /sys/module/nvme_core/version'
    ret_list.append(cmd)
    ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
    ret.wait()
    info = str(ret.stdout.read()).replace("b'", '')[:-1]
    ret_list.append(info)
    version = info
    cmd = 'cat /sys/module/nvme_core/srcversion'
    ret_list.append(cmd)
    ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
    ret.wait()
    info = str(ret.stdout.read()).replace("b'", '')[:-1]
    ret_list.append(info)
    srcversion = info
    logger.info('check version({})and src_version({})'.format(version, srcversion))

    cmd = 'modinfo nvme-core'
    ret_list.append(cmd)
    ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
    ret.wait()
    info = str(ret.stdout.read()).replace("b'", '')[:-1]
    ret_list.append(info)
    logger.info('Check OceanStor_NOF_Enabler tool: {}'.format(info))
    if version in info and srcversion in info:
        logger.info('Check OceanStor_NOF_Enabler tool: first step pass')
        cmd = 'systemctl status nvme-snsd'
        ret_list.append(cmd)
        ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
        ret.wait()
        info = str(ret.stdout.read()).replace("b'", '')[:-1]
        ret_list.append(info)
        logger.info('Check OceanStor_NOF_Enabler tool: {}'.format(info))

        if '(running)' in info:
            logger.info('Check OceanStor NOF Enabler tool: pass')
        else:
            logger.info('Check OceanStor NOF Enabler tool: not pass')
            status = 0
            return status, 'OceanStor NOF Enabler check error'

    else:
        logger.info('Check OceanStor NOF Enabler tool: not pass')
        status = 0
        return status, 'OceanStor NOF Enabler check error'
    status = 1
    return status, None


start_time = time.localtime(time.time())
start_time = time.strftime("%Y-%m-%d %H:%M:%S", start_time)

status_code, error_code = oceanstor_nof_enabler_check()

end_time = time.localtime(time.time())
end_time = time.strftime("%Y-%m-%d %H:%M:%S", end_time)
res = {'config_item': 'check_oceanstor_nof', 'start_time': start_time, 'end_time': end_time,
       'status': status_code, 'error_code': error_code, "origin_info": '\n'.join(ret_list)}
res = str(json.dumps(res))
with open('../result/check_oceanstor_nof_result.json', 'w') as f:
    f.write(res)
print('Execution completed')
