#!/usr/bin/python
# -*- coding: utf-8 -*-

import subprocess
import logging
import json
import time

ret = subprocess.Popen('mkdir ../log/', shell=True)
ret.wait()
ret = subprocess.Popen('mkdir ../result/', shell=True)
ret.wait()
logger = logging.Logger("first_logger")
my_handler = logging.FileHandler('../log/config_network.log')
my_handler.setLevel(logging.INFO)
my_format = logging.Formatter("%(asctime)s %(message)s line:%(lineno)d")
my_handler.setFormatter(my_format)
logger.addHandler(my_handler)

ret_list = []


def set_vlan():
    with open('../config/network_config.json', 'r') as f:
        config_list = json.load(f)

    cmd = 'cat /etc/os-release |grep ^NAME'
    ret_list.append(cmd)
    ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
    ret.wait()
    info = str(ret.stdout.read()).replace("b'", '')[:-1]
    ret_list.append(info)
    logger.info('Check system version: {}'.format(info))
    vlan_info = {}
    for i in config_list['network_config']:
        vlan_info[i["port_name"]] = [i['vlan_id'], i['host_ip'], i['mtu'], i['netmask']]

    if 'Ubuntu' in info:
        for i in vlan_info.keys():
            port_name = i
            mtu = vlan_info[i][2]
            ifcg_path = '/etc/netplan/ifcfg-{}.yaml'.format(port_name)
            cmd = 'cd /etc/netplan && ls'
            ret_list.append(cmd)
            ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
            ret.wait()
            info = str(ret.stdout.read()).replace("b'", '')[:-1]
            ret_list.append(info)
            logger.info('Check NIC configuration directory: {}'.format(info))

            if port_name not in info:
                logger.info('Generate NIC configuration file: {}'.format(port_name))
                cmd = 'echo -e "network:\n' \
                      '  version: 2\n' \
                      '  renderer: networkd\n' \
                      '  ethernets:\n' \
                      '    {}:' \
                      '      dhcp4: no' \
                      '      dhcp6: no\n' \
                      '     mtu: {}"  > {}'.format(port_name, mtu, ifcg_path)
                logger.info('Generate NIC({})configuration file:{}'.format(port_name, cmd))
                ret = subprocess.Popen(cmd, shell=True)
                ret.wait()

            cmd = 'cat {}'.format(ifcg_path)
            ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
            ret.wait()
            info = str(ret.stdout.read()).replace("b'", '')[:-1]
            logger.info('View NIC configuration file:{}'.format(info))
            if str(ret.stderr.read()) != "b''" and str(ret.stderr.read()) != "":
                logger.info('NIC configuration file not found')
                status = 0
                return status, 'ifcg file not found'

            # 修改网卡配置
            if 'mtu' not in info:
                ret = subprocess.Popen('echo "      mtu: {}" >> {}'.format(mtu, ifcg_path), shell=True)
                ret.wait()

            else:
                ret = subprocess.Popen('sed -i "      mtu: .*/      mtu: {}/" {}'.format(mtu, ifcg_path), shell=True)
                ret.wait()
            ret = subprocess.Popen('sed -i "s/      dhcp4: .*/      dhcp4: no/" {}'.format(ifcg_path), shell=True)
            ret.wait()
            ret = subprocess.Popen('sed -i "s/      dhcp6: .*/      dhcp4: no/" {}'.format(ifcg_path), shell=True)
            ret.wait()

            # 创建VLAN
            net_mask = vlan_info[i][3].split('.')
            mask_bin = ''
            for k in net_mask:
                mask_bin += str((bin(int(k))))[2:]
            mask_num = 0
            for j in mask_bin:
                if j == '1':
                    mask_num += 1

            host_ip = vlan_info[i][1]
            vlan_id = vlan_info[i][0]
            vlan_name = '{}.{}'.format(port_name, vlan_id)
            cmd = 'echo -e "  vlans:\n' \
                  '    {}:\n' \
                  '      id: {}\n' \
                  '      mtu: {}\n' \
                  '      link: {}\n' \
                  '      addresses: ["{}/{}"]"  >> {}'.format(vlan_name, vlan_id, mtu, port_name,
                                                              host_ip, mask_num, ifcg_path)
            logger.info('Add vlan configuration information: {}'.format(cmd))
            ret = subprocess.Popen(cmd, shell=True)
            ret.wait()
            cmd = 'cat {}'.format(ifcg_path)
            ret_list.append(cmd)
            ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
            ret.wait()
            info = str(ret.stdout.read()).replace("b'", '')[:-1]
            ret_list.append(info)
            logger.info('View the modified NIC configuration file: {}'.format(info))

            ret = subprocess.Popen('netplan apply', shell=True)
            ret.wait()
            cmd = 'ifconfig {}'.format(vlan_name)
            ret_list.append(cmd)
            ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
            ret.wait()
            info = str(ret.stdout.read()).replace("b'", '')[:-1]
            ret_list.append(info)
            logger.info('View the IP information of the VLAN network port: {}'.format(info))

            # 检查VLAN配置
            if 'RUNNING' in info and host_ip in info:
                logger.info('vlan配置已生效')
                cmd = 'apt-get intstall rc'
                ret_list.append(cmd)
                ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
                ret.wait()
                info = str(ret.stdout.read()).replace("b'", '')[:-1]
                ret_list.append(info)
                logger.info('Install rc tool:{}'.format(info))

                cmd = 'echo "sudo ip link set dev {} type vlan egress 0:3 1:3 2:3 3:3 4:3 5:3 6:3 7:3"' \
                      ' >> {}'.format(vlan_name, ifcg_path)
                logger.info('Add valn priority configuration information: {}'.format(cmd))
                ret = subprocess.Popen(cmd, shell=True)
                ret.wait()
                cmd = 'cat /proc/net/vlan/{}'.format(vlan_name)
                ret_list.append(cmd)
                ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
                ret.wait()
                info = str(ret.stdout.read()).replace("b'", '')[:-1]
                ret_list.append(info)
                logger.info('View VLAN configuration information: {}'.format(info))

                if '0:3 1:3 2:3 3:3 4:3 5:3 6:3 7:3' in info:
                    logger.info('VLAN priority configuration has taken effect')
                else:
                    logger.info('VLAN priority configuration does not take effect')
                    status = 0
                    return status, 'vlan priority error'
            else:
                logger.info('VLAN configuration does not take effect')
                status = 0
                return status, 'vlan configuration error'

    else:
        for i in vlan_info.keys():
            port_name = i
            mtu = vlan_info[i][2]
            ifcg_path = '/etc/sysconfig/network-scripts/ifcfg-{}'.format(port_name)
            cmd = 'cd /etc/sysconfig/network-scripts && ls'
            ret_list.append(cmd)
            ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
            ret.wait()
            info = str(ret.stdout.read()).replace("b'", '')[:-1]
            ret_list.append(info)
            logger.info('View NIC configuration directory: {}'.format(info))

            if port_name not in info:
                logger.info('Generate NIC configuration file: {}'.format(port_name))
                cmd = 'echo -e "TYPE=Ethernet\n' \
                      'PROXY_METHOD=none\n' \
                      'BROWSER_ONLY=no\n' \
                      'BOOTPROTO=none\n' \
                      'DEFROUTE=yes' \
                      'IPV6INIT=no\n' \
                      'IPV6_AUTOCONF=no\n' \
                      'NAME={}' \
                      'DEVICE={}' \
                      'ONBOOT=yes\n' \
                      'MTU={}"  > {}'.format(port_name, port_name, mtu, ifcg_path)
                logger.info('Generate NIC({}) configuration file: {}'.format(port_name, cmd))
                ret = subprocess.Popen(cmd, shell=True)
                ret.wait()

            cmd = 'cat {}'.format(ifcg_path)
            ret_list.append(cmd)
            ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
            ret.wait()
            info = str(ret.stdout.read()).replace("b'", '')[:-1]
            ret_list.append(info)
            logger.info('View NIC configuration files: {}'.format(info))

            if str(ret.stderr.read()) != "b''" and str(ret.stderr.read()) != "":
                logger.info('NIC configuration file not found')
                status = 0
                return status, 'ifcg file not found'

            # 修改网卡配置
            ret = subprocess.Popen('sed -i "s/ONBOOT=.*/ONBOOT=yes/" {}'.format(ifcg_path), shell=True)
            ret.wait()
            ret = subprocess.Popen('sed -i "s/IPV6INIT=.*/IPV6INIT=no/" {}'.format(ifcg_path), shell=True)
            ret.wait()
            ret = subprocess.Popen('sed -i "s/IPV6_AUTOCONF=.*/IPV6_AUTOCONF=no/" {}'.format(ifcg_path), shell=True)
            ret.wait()
            if 'BOOTPROTO' not in info:
                ret = subprocess.Popen('echo "BOOTPROTO=none" >> {}'.format(ifcg_path), shell=True)
                ret.wait()
            else:
                ret = subprocess.Popen('sed -i "s/BOOTPROTO=.*/BOOTPROTO=none/" {}'.format(ifcg_path), shell=True)
                ret.wait()
            if 'MTU' not in info:
                ret = subprocess.Popen('echo "MTU={}" >> {}'.format(mtu, ifcg_path), shell=True)
                ret.wait()
            else:
                ret = subprocess.Popen('sed -i "s/MTU=.*/MTU={}/" {}'.format(mtu, ifcg_path), shell=True)
                ret.wait()
            # 创建VLAN文件
            vlan_id = vlan_info[i][0]
            vlan_path = '/etc/sysconfig/network-scripts/ifcfg-{}.{}'.format(port_name, vlan_id)
            vlan_name = '{}.{}'.format(port_name, vlan_id)
            host_ip = vlan_info[i][1]
            net_mask = vlan_info[i][3]
            cmd = 'echo -e "BOOTPROTO=static\n' \
                  'IPV4_FAILURE_FATAL=no\n' \
                  'NAME={}\n' \
                  'DEVICE={}\n' \
                  'ONBOOT=yes\n' \
                  'MTU={}\nVLAN=yes\n' \
                  'IPADDR={}\n' \
                  'NETMASK={}\n' \
                  'VLAN_EGRESS_PRIORITY_MAP=0:3,1:3,2:3,3:3,4:3,5:3,6:3,7:3" > {}'.format(vlan_name, vlan_name, mtu,
                                                                                          host_ip, net_mask, vlan_path)
            logger.info('Generate valn configuration file: {}'.format(cmd))
            ret = subprocess.Popen(cmd, shell=True)
            ret.wait()

            cmd = 'cat {}'.format(vlan_path)
            ret_list.append(cmd)
            ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
            ret.wait()
            info = str(ret.stdout.read()).replace("b'", '')[:-1]
            ret_list.append(info)
            logger.info('View the modified NIC configuration file: {}'.format(info))

            # 重启网卡
            ret = subprocess.Popen('service NetworkManager restart', shell=True)
            ret.wait()
            ret = subprocess.Popen('ifdown {}'.format(port_name), shell=True)
            ret.wait()
            ret = subprocess.Popen('ifup {}'.format(port_name), shell=True)
            ret.wait()

            ret = subprocess.Popen('ifdown {}'.format(vlan_name), shell=True)
            ret.wait()
            ret = subprocess.Popen('ifup {}'.format(vlan_name), shell=True)
            ret.wait()

            cmd = 'ifconfig {}'.format(vlan_name)
            ret_list.append(cmd)
            ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
            ret.wait()
            info = str(ret.stdout.read()).replace("b'", '')[:-1]
            ret_list.append(info)
            logger.info('View the IP information of the VLAN network port:{}'.format(info))
            # 检查VLAN配置
            if 'RUNNING' in info and host_ip in info:
                logger.info('vlan configuration has taken effect')
                cmd = 'cat /proc/net/vlan/{}'.format(vlan_name)
                ret_list.append(cmd)
                ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
                ret.wait()
                info = str(ret.stdout.read()).replace("b'", '')[:-1]
                ret_list.append(info)
                logger.info('View vlan configuration:{}'.format(info))
                if '0:3 1:3 2:3 3:3 4:3 5:3 6:3 7:3' in info:
                    logger.info('vlan priority configuration has taken effect')
                else:
                    logger.info('vlan priority configuration has not taken effect')
                    status = 0
                    return status, 'vlan priority error'
            else:
                logger.info('vlan configuration has not taken effect')
                status = 0
                return status, 'vlan configuration error'
    status = 1
    return status, None


logger.info('Start configuring the host network.')
start_time = time.localtime(time.time())
start_time = time.strftime("%Y-%m-%d %H:%M:%S", start_time)
status_code, error_code = set_vlan()

end_time = time.localtime(time.time())
end_time = time.strftime("%Y-%m-%d %H:%M:%S", end_time)
res = {'config_item': 'config_network', 'start_time': start_time, 'end_time': end_time,
       'status': status_code, 'error_code': error_code, "origin_info": '\n'.join(ret_list)}
res = str(json.dumps(res))
with open('../result/config_network_result.json', 'w') as f:
    f.write(res)

print('Execution completed')
