#!/usr/bin/python
# -*- coding: utf-8 -*-

import subprocess
import logging
import json
import time

logger = logging.Logger("first_logger")
my_handler = logging.FileHandler('../log/config_pfc.log')
my_handler.setLevel(logging.INFO)
my_format = logging.Formatter("%(asctime)s %(message)s line:%(lineno)d")
my_handler.setFormatter(my_format)
logger.addHandler(my_handler)

ret_list = []


def set_pfc():
    logger.info('Start configuring the PFC')
    with open('../config/network_config.json', 'r') as f:
        config_list = json.load(f)

    pfc_info = {}
    for i in config_list['network_config']:
        pfc_info[i["port_name"]] = i['flow_control_mode']

    port_names = []
    for i in pfc_info.keys():
        if pfc_info[i] == 'PCP':
            cmd = 'echo "mlnx_qos -i {} --pfc 0,0,0,1,0,0,0,0" >> /etc/rc.d/rc.local'.format(i)
            ret = subprocess.Popen(cmd, shell=True)
            ret.wait()
            ret = subprocess.Popen('chmod u+x /etc/rc.d/rc.local', shell=True)
            ret.wait()
            cmd = 'mlnx_qos -i {} --pfc 0,0,0,1,0,0,0,0 --trust pcp'.format(i)
            print(cmd)
            ret = subprocess.Popen(cmd, shell=True)
            ret.wait()

        elif pfc_info[i] == 'DSCP':
            cmd = 'echo -e "#!/bin/sh\n' \
                  '# DSCP\n' \
                  'netdevs_dscp=()\n' \
                  'netdev=$1\n' \
                  'action=$2\n' \
                  'logger \"$0: Action: $action, netdev: $netdev.\"\n' \
                  'if [ \"x${action}\" != "xpre-up" ]; then\n' \
                  ' exit 0\n' \
                  'fi\n' \
                  '# DSCP\n' \
                  'if [[ "x${netdevs_dscp[@]}" =~ "x${netdev}" ]]; then\n' \
                  ' ibdev=$(/usr/local/bin/ibdev2netdev | /usr/bin/grep -w ${netdev} | /usr/bin/awk \'{print $1}\')\n' \
                  ' /usr/local/bin/mlnx_qos -i ${netdev} --pfc 0,0,0,1,0,0,0,0 --trust=dscp\n' \
                  ' /usr/local/bin/cma_roce_tos -d ${ibdev} -t 104\n' \
                  ' logger "$0: Set ${netdev} pfc 0,0,0,1,0,0,0 trust dscp, set ${ibdev} tos 104."\n' \
                  ' exit 0\n' \
                  'fi" > /etc/NetworkManager/dispatcher.d/pre-up.d/set-nvmeof-qos'
            logger.info('Generate DSCP configuration file:{}'.format(cmd))
            ret = subprocess.Popen(cmd, shell=True)
            ret.wait()
            port_names.append(i)

    if len(port_names) > 0:
        port_name = ' '.join(port_names)
        ret = subprocess.Popen('sed -i "s/netdevs_dscp=(.*/netdevs_dscp=({})/"'
                         ' /etc/NetworkManager/dispatcher.d/pre-up.d/set-nvmeof-qos'.format(port_name), shell=True)
        ret.wait()
        ret = subprocess.Popen('chmod u+x /etc/NetworkManager/dispatcher.d/pre-up.d/set-nvmeof-qos', shell=True)
        ret.wait()

    for port_name in port_names:
        cmd = 'mlnx_qos -i {} --pfc 0,0,0,1,0,0,0,0 --trust dscp'.format(port_name)
        print(cmd)
        ret = subprocess.Popen(cmd, shell=True)
        ret.wait()

    for i in pfc_info.keys():
        cmd = 'mlnx_qos -i {}'.format(i)
        ret_list.append(cmd)
        ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
        ret.wait()
        info = str(ret.stdout.read()).replace("b'", '')[:-1]
        ret_list.append(info)
        logger.info('View PFC configuration: {}'.format(info))
        if pfc_info[i] == 'PCP':
            mode = 'state: pcp'
        elif pfc_info[i] == 'DSCP':
            mode = 'state: dscp'
        if mode in info and '0   0   0   1   0   0   0   0' in info:
            logger.info('PFC configuration has taken effect')
        else:
            logger.info('PFC configuration has not taken effect')
            status = 0
            return status, 'PFC configuration error'
    status = 1
    return status, None


start_time = time.localtime(time.time())
start_time = time.strftime("%Y-%m-%d %H:%M:%S", start_time)
status_code, error_code = set_pfc()

end_time = time.localtime(time.time())
end_time = time.strftime("%Y-%m-%d %H:%M:%S", end_time)
res = {'config_item': 'config_pfc', 'start_time': start_time, 'end_time': end_time,
       'status': status_code, 'error_code': error_code, "origin_info": '\n'.join(ret_list)}
res = str(json.dumps(res))

with open('../result/config_pfc_result.json', 'w') as f:
    f.write(res)

print('Execution completed')
