#!/usr/bin/python
# -*- coding: utf-8 -*-

import subprocess
import logging
import json
import time

logger = logging.Logger("first_logger")
my_handler = logging.FileHandler('../log/connect_target.log')
my_handler.setLevel(logging.INFO)
my_format = logging.Formatter("%(asctime)s %(message)s line:%(lineno)d")
my_handler.setFormatter(my_format)
logger.addHandler(my_handler)

ret_list = []


def connect():
    cmd = 'systemctl status nvme-snsd'
    ret_list.append(cmd)
    ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
    ret.wait()
    info = str(ret.stdout.read()).replace("b'", '')[:-1]
    ret_list.append(info)
    logger.info('Check whether OceanStor NOF is running:{}'.format(info))
    if '(running)' in info:
        logger.info('OceanStor NOF has been enabled, and the target has been automatically connected')
        status = 1
        return status, None
    else:
        with open('../config/network_config.json', 'r') as f:
            config_list = json.load(f)

        storage_ips = []
        for i in config_list['network_config']:
            storage_ips.append(i['storage_ip'])

        retry_times = 0
        for storage_ip in storage_ips:
            cmd = 'ping -c 3 {}'.format(storage_ip)
            ret_list.append(cmd)
            ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
            ret.wait()
            info = str(ret.stdout.read()).replace("b'", '')[:-1]
            ret_list.append(info)
            logger.info('ping storage ip: {}'.format(info))

            if '3 received, 0% packet loss' in info:
                cmd = 'nvme discover -t rdma -a {}'.format(storage_ip)
                ret_list.append(cmd)
                ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
                ret.wait()
                info = str(ret.stdout.read()).replace("b'", '')[:-1]
                ret_list.append(info)
                logger.info('Discover the target: {}'.format(info))
                print(info)
                nqn = info.split(': ')[7].replace(r'\ntraddr', '')
                print(nqn)
                ret = subprocess.Popen('nvme connect -t rdma -a {} -n {}'.format(storage_ip, nqn), shell=True)
                ret.wait()
                cmd = 'nvme list-subsys'
                ret_list.append(cmd)
                ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
                ret.wait()
                info = str(ret.stdout.read()).replace("b'", '')[:-1]
                ret_list.append(info)
                logger.info('Confirm that the target device is successfully connected:{}'.format(info))
                if storage_ip in info and ' live' in info:
                    logger.info('{}:Target connected successfully'.format(storage_ip))

                else:
                    if retry_times < 3:
                        logger.info('{}:The target failed to connect for the ({}) time, try again later'.format(
                            storage_ip, retry_times + 1))
                        retry_times += 1
                        storage_ips.append(storage_ip)

                    else:
                        logger.info('{}:The target failed to connect (3) times in a row.'.format(storage_ip))
                        status = 0
                        return status, 'connect target error'

            else:
                logger.info(
                    'ping storage ip:{} failed, Please check whether the storage test configuration is correct'.format(
                        storage_ip))
                status = 0
                return status, 'ping storage ip error'

        #设置开机自启动
        cmd = 'echo -e "[Unit]\n' \
              'Description=NVMf auto discovery service\n' \
              'Requires=network.target\n' \
              'StartLimitInterval=320\n' \
              'StartLimitBurst=5\n' \
              'After=systemd-modules-load.service network.target network-online.target\n' \
              '[Service]\n' \
              'Type=idle\n' \
              'ExecStart=/usr/sbin/nvme connect-all\n' \
              'StandardOutput=journal\n' \
              'Restart=always\n' \
              'RestartSec=60\n' \
              '[Install]\n' \
              'WantedBy=multi-user.target timers.target\n" ' \
              '> /etc/systemd/system/nvme_fabrics_persistent.service'
        logger.info('Generate service service file:{}'.format(cmd))
        ret = subprocess.Popen(cmd, shell=True)
        ret.wait()
        cmd = 'systemctl enable nvme_fabrics_persistent.service'
        ret_list.append(cmd)
        ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
        ret.wait()
        info = str(ret.stdout.read()).replace("b'", '')[:-1]
        ret_list.append(info)
        for storage_ip in storage_ips:
            cmd = 'echo "--transport rdma --traddr {} --trsvcid 4420" ' \
                  '>> /etc/nvme/discovery.conf'.format(storage_ip)
            logger.info('Write discovery.conf file:{}'.format(cmd))
            ret = subprocess.Popen(cmd, shell=True)
            ret.wait()

        status = 1
        return status, None


start_time = time.localtime(time.time())
start_time = time.strftime("%Y-%m-%d %H:%M:%S", start_time)

status_code, error_code = connect()

end_time = time.localtime(time.time())
end_time = time.strftime("%Y-%m-%d %H:%M:%S", end_time)
res = {'config_item': 'connect_target', 'start_time': start_time, 'end_time': end_time,
       'status': status_code, 'error_code': error_code, "origin_info": '\n'.join(ret_list)}
res = str(json.dumps(res))

with open('../result/connect_target_result.json', 'w') as f:
    f.write(res)

print('Execution completed')
