#!/usr/bin/python
# -*- coding: utf-8 -*-

import json
import logging
import subprocess
import time

ret = subprocess.Popen('mkdir ../log/', shell=True)
ret.wait()
ret = subprocess.Popen('mkdir ../result/', shell=True)
ret.wait()
logger = logging.Logger("first_logger")
my_handler = logging.FileHandler('../log/install_mlnx_tools.log')
my_handler.setLevel(logging.INFO)
my_format = logging.Formatter("%(asctime)s %(message)s line:%(lineno)d")
my_handler.setFormatter(my_format)
logger.addHandler(my_handler)

ret_list = []


def copy_files(file_list, dts_path, src_path=''):
    for file in file_list:
        if src_path:
            file = src_path + '/' + file
        ret = subprocess.Popen('cp {} {} -fv'.format(file, dts_path), shell=True, cwd='../install')
        ret.wait()


def mlnx_install():
    logger.info('Start install mlnx-tools')
    cmd = 'ls |grep mlnx-tools'
    ret_list.append(cmd)
    ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, cwd='../install')
    ret.wait()
    info = str(ret.stdout.read()).replace("b'", '')[:-1]
    ret_list.append(info)
    logger.info('Check mlnx-tools installation package:{}'.format(info))
    # python3 会带\\n的结束符，python2不带
    mlnx_name = info.split('\\n')[0]
    cmd = 'tar -zxvf {}'.format(mlnx_name)
    ret_list.append(cmd)
    ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, cwd='../install')
    ret.wait()
    info = str(ret.stdout.read()).replace("b'", '')[:-1]
    ret_list.append(info)
    logger.info('mlnx-tools unpack:{}'.format(info))

    mlnx_dir_name = mlnx_name.strip('.tar.gz')
    ret_list.append(cmd)
    cmd = 'cd {}/ofed_scripts/utils/;python3 setup.py install'.format(mlnx_dir_name)
    ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, cwd='../install')
    ret.wait()
    info = str(ret.stdout.read()).replace("b'", '')[:-1]
    ret_list.append(info)
    logger.info('mlnx-tools installation process:{}'.format(info))
    copy_files(file_list=['mlnx_qos', 'mlnx_perf', 'mlnx_qcn', 'mlnx_tune', 'mlnx_dump_parser',
                          'mlx_fs_dump', 'mlnx_mcg'],
               dts_path='/usr/local/bin/', src_path='{}/ofed_scripts/utils/build/scripts*'.format(mlnx_dir_name))
    copy_files(file_list=['cma_roce_tos', 'ibdev2netdev'],
               dts_path='/usr/local/bin/', src_path='{}/ofed_scripts'.format(mlnx_dir_name))
    file_list = ['mlnx_qos', 'mlnx_perf', 'mlnx_qcn', 'mlnx_tune', 'mlnx_dump_parser', 'mlx_fs_dump', 'mlnx_mcg',
                 'cma_roce_tos', 'ibdev2netdev']
    for file in file_list:
        ret = subprocess.Popen('chmod u+x /usr/local/bin/{}'.format(file), shell=True)
        ret.wait()
    ret = subprocess.Popen('rm -rf {}'.format(mlnx_dir_name), shell=True, cwd='../install')
    ret.wait()
    logger.info('mlnx tool: Installed')
    return 1, None


start_time = time.localtime(time.time())
start_time = time.strftime("%Y-%m-%d %H:%M:%S", start_time)

status_code, error_code = mlnx_install()

end_time = time.localtime(time.time())
end_time = time.strftime("%Y-%m-%d %H:%M:%S", end_time)
res = {'config_item': 'install_mlnx_tools', 'start_time': start_time, 'end_time': end_time,
       'status': status_code, 'error_code': error_code, "origin_info": '\n'.join(ret_list)}
res = str(json.dumps(res))
with open('../result/install_mlnx_tools_result.json', 'w') as f:
    f.write(res)
print('Execution completed')
