#!/usr/bin/python
# -*- coding: utf-8 -*-

import json
import subprocess
import logging
import time

ret = subprocess.Popen('mkdir ../log/', shell=True)
ret.wait()
ret = subprocess.Popen('mkdir ../result/', shell=True)
ret.wait()
logger = logging.Logger("first_logger")
my_handler = logging.FileHandler('../log/install_nvme_cli.log')
my_handler.setLevel(logging.INFO)
my_format = logging.Formatter("%(asctime)s %(message)s line:%(lineno)d")
my_handler.setFormatter(my_format)
logger.addHandler(my_handler)

ret_list = []

PASS = 1
NOT_PASS = 0


def nvme_cli_install():
    logger.info('Start install nvme-cli')
    cmd = 'ls|grep nvme-cli'
    ret_list.append(cmd)
    ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, cwd='../install')
    ret.wait()
    info = str(ret.stdout.read()).replace("b'", '')[:-1]
    ret_list.append(info)
    logger.info('Check nvme-cli install package:{}'.format(info))
    nvme = info.split('\\n')[0]
    cmd = 'rpm -ivh {}'.format(nvme)
    ret_list.append(cmd)
    ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, cwd='../install')
    ret.wait()
    info = str(ret.stdout.read()).replace("b'", '')[:-1]
    ret_list.append(info)
    logger.info('nvme-cli install info:{}'.format(info))
    cmd = 'rpm -qa|grep nvme-cli'
    ret_list.append(cmd)
    ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
    ret.wait()
    info = str(ret.stdout.read()).replace("b'", '')[:-1]
    ret_list.append(info)
    logger.info('Check nvme-cli:{}'.format(info))
    if 'nvme-cli' in info:
        logger.info('nvme-cli tool: install success')
        return PASS, None
    else:
        logger.info('nvme-cli tool:install fail')
        status = NOT_PASS
        return status, 'nvme-cli install error'


start_time = time.localtime(time.time())
start_time = time.strftime("%Y-%m-%d %H:%M:%S", start_time)

status_code, error_code = nvme_cli_install()

end_time = time.localtime(time.time())
end_time = time.strftime("%Y-%m-%d %H:%M:%S", end_time)
res = {'config_item': 'install_nvme_cli', 'start_time': start_time, 'end_time': end_time,
       'status': status_code, 'error_code': error_code, "origin_info": '\n'.join(ret_list)}
res = str(json.dumps(res))
with open('../result/install_nvme_cli_result.json', 'w') as f:
    f.write(res)
print('Execution completed')
