#!/usr/bin/python
# -*- coding: utf-8 -*-

import json
import subprocess
import logging
import time

ret = subprocess.Popen('mkdir ../log/', shell=True)
ret.wait()
ret = subprocess.Popen('mkdir ../result/', shell=True)
ret.wait()
logger = logging.Logger("first_logger")
my_handler = logging.FileHandler('../log/install_oceanstor_nof.log')
my_handler.setLevel(logging.INFO)
my_format = logging.Formatter("%(asctime)s %(message)s line:%(lineno)d")
my_handler.setFormatter(my_format)
logger.addHandler(my_handler)

ret_list = []


def oceanstor_nof_enabler_install():
    logger.info('Start install OceanStor NOF Enabler')
    with open('../config/network_config.json', 'r') as f:
        config_list = json.load(f)

    host_ip_info = {}
    storage_ips = []
    for i in config_list['network_config']:
        if i["host_ip"] not in host_ip_info.keys():
            storage_ips = []
        storage_ips.append(i['storage_ip'])
        host_ip_info[i["host_ip"]] = [i['network_type'], storage_ips]

    sw = ''
    dc = ''
    for i in host_ip_info.keys():
        host_ip = i
        network_type = host_ip_info[i][0]
        if network_type == 'SW':
            sw += '--host-traddr = {} | --protocol = roce\n'.format(host_ip)
        elif network_type == 'DC':
            for storage_ip in host_ip_info[i][1]:
                dc += '--host-traddr = {} | --traddr = {} | --protocol = roce\n'.format(host_ip, storage_ip)

    cmd = 'echo -e "/*----------------------------------------------* \n' \
          '*             Configuration Body                         * \n' \
          '*----------------------------------------------*/\n' \
          '[BASE]\n' \
          '; The restrain time of disconnecting device when net link down. Unit is second.\n' \
          '; The recommended value is 0.\n' \
          'restrain-time = 0\n' \
          '; Set special standard, eg: standard, cm, default value is standard. This parameter is optional.\n' \
          ';--standard = standard\n' \
          '\n[SW]\n' \
          '; Switching network configuration, mandatory: --host-traddr, --protocol\n' \
          '; If "--host-traddr" is set to "any", other IP addresses cannot be configured for the switching network.\n' \
          '; All customer networks support SNSD\n' \
          '; eg:\n' \
          ';       --host-traddr = xxxx | --protocol = (roce/tcp/iscsi)\n' \
          '{}' \
          '\n[DC]\n' \
          '; Configuration of the directly connected network, mandatory: --host-traddr, --protocol, --traddr\n' \
          '; eg:\n' \
          ';       --host-traddr = xxxx | --traddr = xxxx | --protocol = (roce/tcp/iscsi)\n' \
          '{}" > /etc/nvme/snsd.conf'.format(sw, dc)
    logger.info('Generate /etc/nvme/snsd.conf file:{}'.format(cmd))
    ret = subprocess.Popen(cmd, shell=True)
    ret.wait()
    cmd = 'systemctl status nvme-snsd'
    ret_list.append(cmd)
    ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
    ret.wait()
    info = str(ret.stdout.read()).replace("b'", '')[:-1]
    ret_list.append(info)
    logger.info('Check OceanStor NOF whether is installed:{}'.format(info))
    if '(running)' in info:
        cmd = 'systemctl restart nvme-snsd.service'
        ret_list.append(cmd)
        ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
        ret.wait()
        logger.info('OceanStor NOF Enabler has installed，nvme-snsd service restarted.')
        return 1, 'server has been restarted'

    cmd = 'ls |grep OceanStor_NOF_Enabler'
    ret_list.append(cmd)
    ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, cwd='../install')
    ret.wait()
    info = str(ret.stdout.read()).replace("b'", '')[:-1]
    ret_list.append(info)
    logger.info('Check OceanStor NOF Enabler install package:{}'.format(info))
    nof_name = info.split('\\n')[0]
    logger.info('nof_name:{}'.format(nof_name))
    cmd = 'unzip {}'.format(nof_name)
    ret_list.append(cmd)
    ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, cwd='../install')
    ret.wait()
    info = str(ret.stdout.read()).replace("b'", '')[:-1]
    ret_list.append(info)
    logger.info('OceanStor NOF Enabler unpack:{}'.format(info))
    nof_dir_name = 'OceanStor\ NOF\ Enabler'
    cmd = 'cd {}/ && sh install.sh'.format(nof_dir_name)
    ret_list.append(cmd)
    ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, cwd='../install')
    ret.wait()
    info = str(ret.stdout.read()).replace("b'", '')[:-1]
    ret_list.append(info)
    logger.info('OceanStor NOF Enabler install process:{}'.format(info))

    time.sleep(3)
    cmd = 'systemctl status nvme-snsd'
    ret_list.append(cmd)
    ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
    ret.wait()
    info = str(ret.stdout.read()).replace("b'", '')[:-1]
    ret_list.append(info)
    logger.info('Check OceanStor NOF running status:{}'.format(info))
    if '(running)' in info:
        logger.info('OceanStor NOF Enabler is activated.')
        return 1, 'host needs to be restarted'
    else:
        logger.info('OceanStor NOF Enabler is not enabled.')
        status = 0
        return status, 'OceanStor NOF Enabler not running'


start_time = time.localtime(time.time())
start_time = time.strftime("%Y-%m-%d %H:%M:%S", start_time)

status_code, error_code = oceanstor_nof_enabler_install()

end_time = time.localtime(time.time())
end_time = time.strftime("%Y-%m-%d %H:%M:%S", end_time)
res = {'config_item': 'install_oceanstor_nof', 'start_time': start_time, 'end_time': end_time,
       'status': status_code, 'error_code': error_code, "origin_info": '\n'.join(ret_list)}
res = str(json.dumps(res))
with open('../result/install_oceanstor_nof_result.json', 'w') as f:
    f.write(res)
print('Execution completed')
