#!/usr/bin/python
# -*- coding: utf-8 -*-

import json
import subprocess
import logging
import time

logger = logging.Logger("first_logger")
my_handler = logging.FileHandler('../log/load_driver.log')
my_handler.setLevel(logging.INFO)
my_format = logging.Formatter("%(asctime)s %(message)s line:%(lineno)d")
my_handler.setFormatter(my_format)
logger.addHandler(my_handler)

ret_list = []


def loaddriver():
    logger.info('Load driver')
    ret = subprocess.Popen('modprobe nvme-rdma', shell=True)
    ret.wait()
    ret = subprocess.Popen('modprobe mlx5_ib', shell=True)
    ret.wait()
    cmd = 'lsmod | grep rdma'
    ret_list.append(cmd)
    ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
    ret.wait()
    info = str(ret.stdout.read()).replace("b'", '')[:-1]
    ret_list.append(info)
    logger.info('lsmod | grep rdma:{}'.format(info))
    if 'nvme_rdma' in info and 'mlx5_ib' in info:
        logger.info('nvme-rdma、mlx5_ib loaded successfully')
    else:
        logger.info('nvme-rdma、mlx5_ib load failed')
        status = 0
        return status, 'nvme-rdma & mlx5_ib load fail'

    cmd = 'echo -e "nvme-rdma\nmlx5_ib" > /etc/modules-load.d/nvme-rdma.conf'
    ret = subprocess.Popen(cmd, shell=True)
    ret.wait()
    cmd = 'cat /etc/modules-load.d/nvme-rdma.conf'
    ret_list.append(cmd)
    ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
    ret.wait()
    info = str(ret.stdout.read()).replace("b'", '')[:-1]
    ret_list.append(info)
    logger.info('Check whether autostart is configured:{}'.format(info))

    status = 1
    return status, None


start_time = time.localtime(time.time())
start_time = time.strftime("%Y-%m-%d %H:%M:%S", start_time)

status_code, error_code = loaddriver()

end_time = time.localtime(time.time())
end_time = time.strftime("%Y-%m-%d %H:%M:%S", end_time)
res = {'config_item': 'load_driver', 'start_time': start_time, 'end_time': end_time,
       'status': status_code, 'error_code': error_code, "origin_info": '\n'.join(ret_list)}
res = str(json.dumps(res))

with open('../result/load_driver_result.json', 'w') as f:
    f.write(res)

print('Execution completed')
