#!/usr/bin/python
# -*- coding: utf-8 -*-

import json
import re
import subprocess
import logging
import time

ret = subprocess.Popen('mkdir ../log/', shell=True)
ret.wait()
ret = subprocess.Popen('mkdir ../result/', shell=True)
ret.wait()
logger = logging.Logger("first_logger")
my_handler = logging.FileHandler('../log/scan_namespace.log')
my_handler.setLevel(logging.INFO)
my_format = logging.Formatter("%(asctime)s %(message)s line:%(lineno)d")
my_handler.setFormatter(my_format)
logger.addHandler(my_handler)

ret_list = []


def scan_namespace():
    cmd = 'ls | grep nvme'
    ret_list.append(cmd)
    ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, cwd='/dev')
    ret.wait()
    info = str(ret.stdout.read()).replace("b'", '')[:-1]
    ret_list.append(info)
    ports = info.split("\\n" if "\\n" in info else "\n")[:-1]
    for port in ports:
        if not re.search('nvme\d+n\d+|nvme-fabrics', port):
            cmd = 'nvme ns-rescan /dev/{}'.format(port)
            ret_list.append(cmd)
            ret = subprocess.Popen(cmd, shell=True)
            ret.wait()

    # 建联后不能立刻查询设备信息，以2秒为周期进行重试直至成功，超过1分钟不再等待
    retry_count = 0
    while retry_count < 30:
        cmd = 'nvme list'
        ret_list.append(cmd)
        ret = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
        ret.wait()
        info = str(ret.stdout.read()).replace("b'", '')[:-1]
        retry_count += 1

        if info is None or "failed" in info:
            time.sleep(2)
        else:
            break

    ret_list.append(info)
    logger.info('Scan Namespace:{}'.format(info))
    if '/dev/nvme' in info:
        status = 1
        return status, None
    else:
        logger.info('Scan Namespace is empty.')
        status = 0
        return status, 'namespace is none'


start_time = time.localtime(time.time())
start_time = time.strftime("%Y-%m-%d %H:%M:%S", start_time)

status_code, error_code = scan_namespace()

end_time = time.localtime(time.time())
end_time = time.strftime("%Y-%m-%d %H:%M:%S", end_time)
res = {'config_item': 'scan_namespace', 'start_time': start_time, 'end_time': end_time,
       'status': status_code, 'error_code': error_code, "origin_info": '\n'.join(ret_list)}
res = str(json.dumps(res))

with open('../result/scan_namespace_result.json', 'w') as f:
    f.write(res)

print('Execution completed')
