# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
import re


def exec_host_cmd(cli, cmd, log_result=True):
    """
    host 连接有效时长为5分钟，在执行试试命令之前需要检查是否连接。如果连接断开重新建立连接后执行命令。

    :param cli: cli对象
    :param cmd: cli命令
    :param log_result: cli命令日志打印标志
    :return: 回显信息。
    """
    if not cli.isConnected():
        cli.reConnect()
    return cli.execCmd(cmd) if log_result else cli.execNoLog(cmd)


def get_err_msg(err_code, lang):
    """
    根据语言和关键字获取报错信息。
    :param err_code: 错误码
    :param lang: 语言环境
    :return: 错误信息。
    """
    from nvme import resource
    err_dict = resource.ERROR_DICT.get(err_code)
    if not err_dict:
        return "--"
    return err_dict.get(lang)


def get_ultra_path_version(ret):
    """
    获取回显中的ultraPath 版本 未安装返回--
    :param ret: 回显信息
    :return: ultraPath 版本
    """
    pattern = r'UltraPath-(\d+\.\d+\.\d+)'
    match = re.search(pattern, ret)
    return match.group(1) if match else "--"
