# coding=UTF-8
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.
from cbb.frame.base import baseUtil
from cbb.frame.context import contextUtil


def execute(context):
    """ 关闭工具时释放TLV和CLI连接

    :param context:
    :return:
    """
    logger = baseUtil.getLogger(context.get("logger"), __file__)
    try:
        contextUtil.destroyTlvConnection(context)
        contextUtil.destroyCliConnection(context)
        contextUtil.destroyOldTlvConnection(context)
        logger.logInfo("Succeed to close tlv and cli connection.")
        return
    except Exception as ex:
        logger.logException(ex)
        return
