# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.frame.detect import detectUtil
from cbb.frame.devGraph import graphUtil
from cbb.frame.tlv import tlvUtil

def checkInterfaceModuleNum(tlv, tlvSvp, logger):
    '''
    @summary: 检测管理板数量否满足要求
    '''
    return detectUtil.detectMgmtInterfaceModuleNum(tlv, logger)

def checkInterfaceModuleStatus(tlv, tlvSvp, logger):
    '''
    @summary: 检测管理板状态
    '''
    return detectUtil.detectMgmtInterfaceModuleStatus(tlv, logger)

def checkDSWNum(tlv, tlvSvp, logger):
    '''
    @summary: 检测PCIe交换机数量否满足要求
    '''
    return detectUtil.detectDSWNum(tlv, logger)

def checkDSWStatus(tlv, tlvSvp, logger):
    '''
    @summary: 检测PCIe交换机数量否满足要求
    '''
    return detectUtil.detectDSWStatus(tlv, logger)

def checkLinkStatus(tlv, tlvSvp, logger):
    '''
    @summary: 检测PCIe交换机数量否满足要求
    '''  
    return detectUtil.detectMgmtPortLinkStatus(tlv, tlvSvp, logger)

def checkInterConnections(tlv, tlvSvp, logger):
    '''
    @summary: 检测管理口连接状态
    '''
    return detectUtil.detectMgmtInterConnections(tlv, tlvSvp, logger)

METHOD_DEFINE_LIST = [
    {
        "name":"checkInterfaceModuleNum",
        "method":checkInterfaceModuleNum,
        "errMsgName":"off.line.mgmt.intf",
        "errMsgArgs":["location"],
        "hightLightType":"ENCLOSURE",
    },
    {
        "name":"checkInterfaceModuleStatus",
        "method":checkInterfaceModuleStatus,
        "errMsgName":"no.running.mgmt.intf",
        "errMsgArgs":["location"],
        "hightLightType":"INTF_MODULE",
    },
    {
        "name":"checkDSWNum",
        "method":checkDSWNum,
        "errMsgName":"dsw.num.insufficent",
        "errMsgArgs":[],
        "hightLightType":"",
    },
    {
        "name":"checkDSWStatus",
        "method":checkDSWStatus,
        "errMsgName":"off.line.pcie.switch",
        "errMsgArgs":["name"],
        "hightLightType":"ENCLOSURE",
    },
    {
        "name":"checkLinkStatus",
        "method":checkLinkStatus,
        "errMsgName":"no.running.mgmt.port",
        "errMsgArgs":["location","sugLocation"],
        "hightLightType":"ETH_PORT",
    },
    {
        "name":"checkInterConnections",
        "method":checkInterConnections,
        "errMsgName":"wrong.inter.conn.mgmt",
        "errMsgArgs":["location","sugPortLocation"],
        "hightLightType":"ETH_PORT",
    },
]


def execute(context, param):
    '''
    @summary: 检测管理网线
    '''

    logger = common.getLogger(context.get("logger"), __file__)
    
    try:
        graphUtil.clearGraph(context)
        tlv = contextUtil.getTlv(context)
        svpRest = contextUtil.getSvpRest(context)
        lang = contextUtil.getLang(context)
        
        (isSuccess, checkMgmtCableResult, mgmtCableHightLightType,checkItemName,infoList) = executeCheck(tlv, svpRest, logger, lang)
        if not isSuccess:      
            contextUtil.setItem(context, "checkMgmtCableResult", checkMgmtCableResult)
            contextUtil.setItem(context, "mgmtCableHightLightType", mgmtCableHightLightType)
            contextUtil.setItem(context, "mgmtCableCheckItem", checkItemName)
            logger.logInfo("checkMgmtCableResult:%s" % checkMgmtCableResult)
            logger.logInfo("mgmtCableHightLightType:%s" % mgmtCableHightLightType)
            logger.logInfo("mgmtCableCheckItem:%s" % checkItemName)
            contextUtil.setCableDetectFailure(context, infoList)
            return
        
        contextUtil.handleSuccess(context)
        return
    except Exception as exception:
        contextUtil.handleDetectException(context, exception)
        logger.logException(exception)
        return

def click(context, param):
    
    logger = common.getLogger(context.get("logger"), __file__)
    graphUtil.clearGraph(context)
    
    checkMgmtCableResult = contextUtil.getItem(context, "checkMgmtCableResult")
    curData = context["curData"]
    logger.logInfo("checkMgmtCable curData:%s" %curData )
    
    idx = int(curData)
    if idx < len(checkMgmtCableResult):
        resultinfo = checkMgmtCableResult[idx]
        logger.logInfo("checkMgmtCable resultinfo:%s" %resultinfo )
        hightLightType = contextUtil.getItem(context, "mgmtCableHightLightType")
        checkItemName = contextUtil.getItem(context, "mgmtCableCheckItem")
        logger.logInfo("checkMgmtCable checkItemName:%s" %checkItemName )
        
        if checkItemName in ["checkInterfaceModuleNum"]:
            parentName = resultinfo.get("location", "").split(".")[0]
            graphUtil.highLightHardwareByName(context, parentName, hightLightType)
            return
        
        if checkItemName in ["checkInterfaceModuleStatus","checkDSWStatus"]:
            intfId = resultinfo.get("id", "")
            graphUtil.highLightHardware(context, intfId, hightLightType)
            return
        
        if checkItemName in ["checkLinkStatus"]:
            location = resultinfo.get("location", "")
            sugLocation = resultinfo.get("sugLocation", "")
            logger.logInfo("location:%s, sugLocation:%s" %(location, sugLocation))
            graphUtil.highLightCableByLocation(context, location, sugLocation, hightLightType)
            return
        
        if checkItemName in ["checkInterConnections"]:
            location = resultinfo.get("location", "")
            sugLocation = resultinfo.get("sugPortLocation", "")
            graphUtil.highLightCableByLocation(context, location, sugLocation, hightLightType) 
            return
              
    return

def executeCheck(tlv, tlvSvp, logger, lang):
    
    checkFlag = True
    detectResult = None
    
    engineNum = len(tlvUtil.getEngineNameList(tlv))
    logger.logInfo("engineNum:%s" % engineNum)
    
    for methodDefine in METHOD_DEFINE_LIST:
        method = methodDefine["method"]
        checkItemName = methodDefine["name"]
        
        if engineNum < 1 and checkItemName in ["checkDSWNum","checkDSWStatus"]:
            continue
        
        detectResult = method(tlv, tlvSvp, logger)
        if len(detectResult) > 0:
            errMsgName = methodDefine["errMsgName"]
            errMsgArgs = methodDefine["errMsgArgs"]
            
            hightLightType = methodDefine["hightLightType"]
            infoList = []
            
            #交换机数量检查
            if checkItemName in ["checkDSWNum"]:
                currentDSWNum = len(detectResult)
                requireDSWNum = 2
                logger.logInfo("currentDSWNum:%s" %str(currentDSWNum))
                if currentDSWNum != requireDSWNum:
                    checkFlag = False 
                    errMsgArgList = [requireDSWNum,currentDSWNum]
                    infoList.append("".join(common.getMsg(lang, errMsgName, tuple(errMsgArgList))))
                    break
                else:
                    continue
                
            checkFlag = False    
            for info in detectResult:
                #获取错误信息参数
                errMsgArgList = []
                for errMsgKey in errMsgArgs:
                    errMsgArgList.append(info.get(errMsgKey,''))
                infoList.append("".join(common.getMsg(lang, errMsgName, tuple(errMsgArgList))))
            break
    
    if checkFlag:
        return (True,"","","","")
    
    return (False,detectResult,hightLightType,checkItemName,infoList)
    