# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.frame.detect import detectUtil
from cbb.frame.devGraph import graphUtil


def checkInterfaceModuleNum(tlv, logger):
    '''
    @summary: 检测PCIe接口卡数量是否满足要求
    '''
    return detectUtil.detectPCIeInterfaceModuleNum(tlv, logger)

def checkInterfaceModuleStatus(tlv, logger):
    '''
    @summary: 检测接口卡状态
    '''
    return detectUtil.detectPCIeInterfaceModuleStatus(tlv, logger)

def checkLinkStatus(tlv,  logger):
    '''
    @summary: 检测PCIe端口状态
    '''
    return detectUtil.detectPCIeLinkStatus(tlv, logger)

def checkInterConnections(tlv, logger):
    '''
    @summary: 检测PCIe连接状态
    '''
    return detectUtil.detectPCIeInterConnections(tlv, logger)

METHOD_DEFINE_LIST = [
    {
        "name":"checkInterfaceModuleNum",
        "method":checkInterfaceModuleNum,
        "errMsgName":"off.line.pcie.intf",
        "errMsgArgs":["location"],
        "hightLightType":"ENCLOSURE",
    },
    {
        "name":"checkInterfaceModuleStatus",
        "method":checkInterfaceModuleStatus,
        "errMsgName":"no.running.pcie.intf",
        "errMsgArgs":["location"],
        "hightLightType":"INTF_MODULE",
    },

    {
        "name":"checkLinkStatus",
        "method":checkLinkStatus,
        "errMsgName":"no.running.pcie.port",
        "errMsgArgs":["location","sugLocation"],
        "hightLightType":"PCIE_PORT",
    },

    {
        "name":"checkInterConnections",
        "method":checkInterConnections,
        "errMsgName":"wrong.inter.conn.pcie",
        "errMsgArgs":["location","sugLocation"],
        "hightLightType":"PCIE_PORT",
    },
]


def execute(context, param):
    '''
    @summary: 脚本执行入口，检测PCIe线缆
    '''
    logger = common.getLogger(context.get("logger"), __file__)
    
    try:
        graphUtil.clearGraph(context)
        tlv = contextUtil.getTlv(context)
        lang = contextUtil.getLang(context)
    
        (isSuccess, checkPCIeCableResult, pcieCableHightLightType,checkItemName,infoList) = executeCheck(tlv, logger, lang)
        if not isSuccess:      
            contextUtil.setItem(context, "checkPCIeCableResult", checkPCIeCableResult)
            contextUtil.setItem(context, "pcieCableHightLightType", pcieCableHightLightType)
            contextUtil.setItem(context, "pcieCableCheckItem", checkItemName)
            logger.logInfo("checkPCIeCableResult:%s" % checkPCIeCableResult)
            logger.logInfo("pcieCableHightLightType:%s" % pcieCableHightLightType)
            logger.logInfo("pcieCableCheckItem:%s" % checkItemName)
            contextUtil.setCableDetectFailure(context, infoList)
            return
        
        contextUtil.handleSuccess(context)
        return
    except Exception as exception:
        contextUtil.handleDetectException(context, exception)
        logger.logException(exception)
        return

def click(context, param):
    
    logger = common.getLogger(context.get("logger"), __file__)
    graphUtil.clearGraph(context)
    
    checkPCIeCableResult = contextUtil.getItem(context, "checkPCIeCableResult")
    curData = context["curData"]
    logger.logInfo("checkPCIeCable curData:%s" %curData )
    
    idx = int(curData)
    if idx < len(checkPCIeCableResult):
        resultinfo = checkPCIeCableResult[idx]
        hightLightType = contextUtil.getItem(context, "pcieCableHightLightType")
        checkItemName = contextUtil.getItem(context, "pcieCableCheckItem")
        logger.logInfo("checkPCIeCable checkItemName:%s" %checkItemName )
        if checkItemName in ["checkInterfaceModuleNum"]:
            parentName = resultinfo.get("location", "").split(".")[0]
            graphUtil.highLightHardwareByName(context, parentName, hightLightType)
            return
        
        if checkItemName in ["checkInterfaceModuleStatus"]:
            intfId = resultinfo.get("id", "")
            graphUtil.highLightHardware(context, intfId, hightLightType)
            return
        
        if checkItemName in ["checkLinkStatus"]:
            location = resultinfo.get("location", "")
            sugLocation = resultinfo.get("sugLocation", "")
            graphUtil.highLightCableByLocation(context, location, sugLocation,hightLightType)
            return
        
        if checkItemName in ["checkInterConnections"]:
            portId = resultinfo.get("id", "")
            sugId = resultinfo.get("sugId", "")
            graphUtil.highLightCable(context, portId, sugId,hightLightType)
            return
            
    return

def executeCheck(tlv, logger, lang):
    
    checkFlag = True
    detectResult = None
    for methodDefine in METHOD_DEFINE_LIST:
        method = methodDefine["method"]
        
        detectResult = method(tlv,logger)
        if len(detectResult) > 0:
            checkFlag = False
            errMsgName = methodDefine["errMsgName"]
            errMsgArgs = methodDefine["errMsgArgs"]
            checkItemName = methodDefine["name"]
            hightLightType = methodDefine["hightLightType"]
            infoList = []
            for info in detectResult:
                #获取错误信息参数
                errMsgArgList = []
                for errMsgKey in errMsgArgs:
                    errMsgArgList.append(info.get(errMsgKey,''))
                infoList.append("".join(common.getMsg(lang, errMsgName, tuple(errMsgArgList))))
            break
    
    if checkFlag:
        return (True,"","","","")
    
    return (False,detectResult,hightLightType,checkItemName,infoList)
    