# -*- coding: UTF-8 -*-

from cbb.business.operate.expansion import common
from cbb.common.dev.utils import skipPowerCableCheck
from cbb.frame.context import contextUtil
from cbb.frame.detect import detectUtil
from cbb.frame.devGraph import graphUtil


def execute(context, param):
    """Detect sas cables.

    :param context:
    :param param:
    :return:
    """

    logger = common.getLogger(context.get("logger"), __file__)

    try:
        if skipPowerCableCheck():
            contextUtil.handleSuccess(context)
            return

        graphUtil.clearGraph(context)
        tlv = contextUtil.getTlv(context)
        svpRest = None
        lang = contextUtil.getLang(context)
        isDorado18000 = contextUtil.getItem(context, 'isDorado18000', False)

        isV5V6HighEnd = contextUtil.getItem(context, 'isV5V6HighEnd', False)

        is_computing_dev = contextUtil.getItem(context, 'is_computing_dev', False)

        (isSuccess, checkPowerCableResult, powerCableHightLightType, infoList) = \
            executeCheck(tlv, svpRest, logger, lang,
                         isDorado18000=isDorado18000,
                         isV5V6HighEnd=isV5V6HighEnd,
                         is_computing_dev=is_computing_dev)
        if not isSuccess:
            contextUtil.setItem(context, "checkPowerCableResult", checkPowerCableResult)
            contextUtil.setItem(context, "powerCableHightLightType", powerCableHightLightType)
            logger.logInfo("checkPowerCableResult:%s" % checkPowerCableResult)
            logger.logInfo("powerCableHightLightType:%s" % powerCableHightLightType)
            contextUtil.setCableDetectFailure(context, infoList)
            return

        contextUtil.handleSuccess(context)
        return
    except Exception as exception:
        contextUtil.handleDetectException(context, exception)
        logger.logException(exception)
        return


def click(context, param):
    logger = common.getLogger(context.get("logger"), __file__)
    graphUtil.clearGraph(context)

    checkPowerCableResult = contextUtil.getItem(context, "checkPowerCableResult")
    curData = context["curData"]
    logger.logInfo("checkPowerCable curData:%s" % curData)

    idx = int(curData)
    if idx < len(checkPowerCableResult):
        resultinfo = checkPowerCableResult[idx]
        hightLightType = contextUtil.getItem(context, "powerCableHightLightType")
        graphUtil.highLightHardware(context, resultinfo.get("id", ""), hightLightType)
    return


def checkPowerModule(tlv, tlvSvp, logger, **kwargs):
    '''
    @summary: 检测电源模块是否在位
    '''
    return detectUtil.detectPowerModule(tlv, tlvSvp, logger, **kwargs)


def checkCable(tlv, tlvSvp, logger, **kwargs):
    '''
    @summary: 检测电源线连接是否正确
    '''
    return detectUtil.detectNoInputPower(tlv, tlvSvp, logger, **kwargs)


METHOD_DEFINE_LIST = [
    {
        "name": "checkPowerModule",
        "method": checkPowerModule,
        "errMsgName": "power.module.insufficient",
        "errMsgArgs": ["name", "location", "needNum", "currentNum"],
        "hightLightType": "ENCLOSURE",
    },
    {
        "name": "checkCable",
        "method": checkCable,
        "errMsgName": "power.off.line",
        "errMsgArgs": ["location"],
        "hightLightType": "POWER",
    },
]


def executeCheck(tlv, tlvSvp, logger, lang, **kwargs):
    checkFlag = True
    detectResult = None
    hightLightType = None
    infoList = []
    for methodDefine in METHOD_DEFINE_LIST:
        method = methodDefine["method"]

        detectResult = method(tlv, tlvSvp, logger, **kwargs)
        if len(detectResult) > 0:
            checkFlag = False
            errMsgName = methodDefine["errMsgName"]
            errMsgArgs = methodDefine["errMsgArgs"]

            hightLightType = methodDefine["hightLightType"]

            for info in detectResult:
                # 获取错误信息参数
                errMsgArgList = []
                for errMsgKey in errMsgArgs:
                    errMsgArgList.append(info.get(errMsgKey, ''))
                infoList.append("".join(common.getMsg(lang, errMsgName, tuple(errMsgArgList))))
            break

    if checkFlag:
        return True, "", "", ""

    return False, detectResult, hightLightType, infoList
