# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.business.operate.expansion.checkSASCableAlarm import SasCableAlarm
from cbb.frame.detect import detectUtil
from cbb.frame.devGraph import graphUtil
from cbb.business.operate.expansion import config


def detectSASLinkConnections(context):
    '''
    @summary: 检测硬盘框链路连接正确性
    '''
    tlv = contextUtil.getTlv(context)
    logger = common.getLogger(context.get("logger"), __file__)
    return detectUtil.detectSASLinkConnections(tlv, logger)

def checkSASLinkStatus(context):
    '''
    @summary: 检测SAS端口状态
    '''
    tlv = contextUtil.getTlv(context)
    logger = common.getLogger(context.get("logger"), __file__)
    logger.logInfo("start check sas cable alarm.")
    item = SasCableAlarm(context)
    results = item.execute()
    if results:
        logger.logInfo("exist sas cable alarm.")
        return results

    if not contextUtil.getItem(context, 'isDorado', False):
        return detectUtil.detectSASLinkStatus(tlv, logger)
    elif contextUtil.getItem(context, 'isDorado18000', False):
        return detectUtil.detectDorado18000SASLinkStatus(context)
    else:
        return []


def detectDcErrNet(context):
    '''
    @summary: 检查异常组网
    '''
    cli = contextUtil.getCli(context)
    lang = contextUtil.getLang(context)
    deepth = contextUtil.getItem(context, "deepth")
    powerType = contextUtil.getItem(context, "powerType")
    return detectUtil.detectDcErrNet(cli, deepth, powerType, lang)

METHOD_DEFINE_LIST = [
    {
        "name":"detectSASLinkConnections",
        "method":detectSASLinkConnections,
        "errMsgName":"wrong.link.conn.sas",
        "errMsgArgs":["name","serialNum"],
        "hightLightType":"",
    },                     
    {
        "name":"checkSASLinkStatus",
        "method":checkSASLinkStatus,
        "errMsgName":"wrong.inter.conn.sas",
        "errMsgArgs":["location","suggestPeerLocation"],
        "hightLightType":"SAS_PORT",
    },
    {
        "name":"detectDcErrNet",
        "method":detectDcErrNet,
        "errMsgName":"sas.dcpower.err.net",
        "errMsgArgs":["port"],
        "hightLightType":"",
    },
]


def execute(context, param):
    '''
    @summary: 检测电源线
    '''

    logger = common.getLogger(context.get("logger"), __file__)
    
    try:
        common.threadUpProcess(context, config.Overtime.SAS_CABLE_ALARM_TIMEOUT + 10,config.IntervalTime.DEFAULT_INTERVAL)
        graphUtil.clearGraph(context)
        tlv = contextUtil.getTlv(context)
        lang = contextUtil.getLang(context)
        
        (isSuccess, checkSASCableResult, sasCableHightLightType,infoList) = executeCheck(context)
        if not isSuccess:      
            contextUtil.setItem(context, "checkSASCableResult", checkSASCableResult)
            contextUtil.setItem(context, "sasCableHightLightType", sasCableHightLightType)
            logger.logInfo("checkSASCableResult:%s" % checkSASCableResult)
            logger.logInfo("sasCableHightLightType:%s" % sasCableHightLightType)
            contextUtil.setCableDetectFailure(context, infoList)
            return
        
        contextUtil.handleSuccess(context)
        return
    except Exception as exception:
        contextUtil.handleDetectException(context, exception)
        logger.logException(exception)
        return
    finally:
        common.finishProcess(context)
        logger.logInfo("update progress over.")

def click(context, param):
    
    logger = common.getLogger(context.get("logger"), __file__)
    graphUtil.clearGraph(context)
    
    checkSASCableResult = contextUtil.getItem(context, "checkSASCableResult", ())
    hightLightType = contextUtil.getItem(context, "sasCableHightLightType", '')
    curData = context["curData"]
    logger.logInfo("checkSASCable curData:%s" %curData )
    
    #为DAE999时不高亮设备图
    if hightLightType == "":
        return
    
    idx = int(curData)
    if idx < len(checkSASCableResult):
        resultinfo = checkSASCableResult[idx]
        location = resultinfo.get("location", "")
        suggestPeerLocation = resultinfo.get("suggestPeerLocation", "")
        hightLightType = resultinfo.get("type", hightLightType)
        if location != "" and suggestPeerLocation != "":
            graphUtil.highLightCableByLocation(context, location, suggestPeerLocation, hightLightType)
        else:
            graphUtil.highLightHardwareByLocation(context,location, hightLightType)
    return

def executeCheck(context):
    
    checkFlag = True
    detectResult = None
    lang = contextUtil.getLang(context)
    
    for methodDefine in METHOD_DEFINE_LIST:
        method = methodDefine["method"]
        
        detectResult = method(context)
        if len(detectResult) > 0:
            checkFlag = False
            errMsgName = methodDefine["errMsgName"]
            errMsgArgs = methodDefine["errMsgArgs"]
                
            hightLightType = methodDefine["hightLightType"]
            infoList = []
            for info in detectResult:
                
                #获取错误信息参数
                errMsgArgList = []
                errMsgArgs = info.get("errMsgArgs",errMsgArgs)
                errMsgName = info.get("errMsgKey",errMsgName)
                for errMsgKey in errMsgArgs:
                    errMsgArgList.append(info.get(errMsgKey,''))
                infoList.append("".join(common.getMsg(lang, errMsgName, tuple(errMsgArgList))))
            break
    
    if checkFlag:
        return (True,"","","")
    
    return (False,detectResult,hightLightType,infoList)
    