# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common

def execute(context):
    '''
    @summary: 检查新集群的控制器数量是否满足要求
    '''
    
    try:
        resultDict = {"flag":True, "errMsg":"", "suggestion":""}
        logger = common.getLogger(context.get("logger"), __file__)
        
        cli = contextUtil.getCli(context)
        lang = contextUtil.getLang(context)
        context["remindInfo"] = common.getDangerNoticeRemindInfo(lang)
        
        newConfigCtrlNum = contextUtil.getItem(context, "newConfigCtrlNum")
        
        version = contextUtil.getItem(context, "productVersion")
        powerOnTime = common.getPoweronCtrlTime(version)
        
        #剩余时间总数
        totalReaminTime = powerOnTime
        contextUtil.setItem(context, "totalReaminTime", totalReaminTime)
        context["curRemainTime"] = totalReaminTime
        common.setExpansionProgress(context, True)
        
        ret = common.checkClusterCtrlsNumWithDetailFor2TO4(context, cli, lang, newConfigCtrlNum, traceType= "11", timeOut = powerOnTime, rollbackInfo={"rollback":True})
        if not ret["flag"]:
            logger.logNoPass("checkClusterCtrlsNum failure(currentCtrlsNum:%s)" % ret["ret"])
            resultDict["flag"] = False
            if ret["errMsg"] != "":
                resultDict["errMsg"], resultDict["suggestion"] = ret["errMsg"], ret["suggestion"]
            else:
                resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "ctrls.number.wrong")
            contextUtil.handleFailure(context, resultDict)
            return 

        contextUtil.setItem(context, contextUtil.EXP_FLOW_STATUS_KEY, contextUtil.EXP_FLOW_STATUS_JOIN_SYS_SUCCESS)
        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
    finally:
        context["remindInfo"] = ""
        context["curRemainTime"] = 0
        common.setExpansionProgress(context, True)