# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common

def execute(context):
    '''
    @summary: 检查原集群控制健康状态和运行状态是否正常
    '''

    try:
        logger = common.getLogger(context.get("logger"), __file__)
        common.setExpSucNotice(context)
        cli = contextUtil.getCli(context)
        lang = contextUtil.getLang(context)
        
        #检查原集群控制健康状态和运行状态是否正常
        checkControllerStatusRetDict = common.checkControllerStatus(context, cli, lang)
        if not checkControllerStatusRetDict["flag"]:
            logger.logNoPass("The status of controllers are abnormal")
            contextUtil.handleFailure(context, checkControllerStatusRetDict)
            return
        
        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
    finally:
        context["remindInfo"] = ""