# -*- coding: UTF-8 -*-
from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import config
from cbb.frame.tlv import tlvUtil
from cbb.frame.context import contextUtil

def execute(context):
    try:
        resultDict = {"flag":True, "errMsg":"", "suggestion":""}
        logger = common.getLogger(context.get("logger"), __file__)
        common.setExpSucNotice(context)
        tlv = contextUtil.getTlv(context)
        lang = contextUtil.getLang(context)
        
        version = tlvUtil.getFullProductVersion(tlv)
        spcVersion = common.getSPCVersion(version)
        contextUtil.setItem(context, "spcVersion", spcVersion)
        
        logger.logInfo("The product Version is %s"%version)
        if spcVersion not in config.NLSAS_UNMATCH_PRODUCT_VERSION:
            contextUtil.handleSuccess(context)
            return
        
        isExistHighDenEnc,highDensityEncList = common.isExistHighDensityEnc(context)
        if not isExistHighDenEnc:
            contextUtil.handleSuccess(context)
            return
        
        diskRecs = tlvUtil.getDiskRecords(tlv)
        nlsasDiskList = common.getUnmatchCompliance10TNlsasDisk(context, highDensityEncList, diskRecs)
        if len(nlsasDiskList) > 0:
            resultDict["flag"] = False
            resultDict["errMsg"],resultDict["suggestion"] = common.getMsg(lang, "check.disk.capacity.over.stantard", ",".join(nlsasDiskList))
            contextUtil.handleFailure(context, resultDict)
            return
        
        contextUtil.handleSuccess(context)
        return
        
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
    finally:
        context["remindInfo"] = ""