# -*- coding: UTF-8 -*-
from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.frame.base import baseUtil

def execute_check(context, retryTime):
    '''
    @summary: 检查ALUA功能是否关闭
    '''
    logger = common.getLogger(context.get("logger"), __file__)
    logger.logInfo("Execute alua check %s times"%retryTime)
    cli = contextUtil.getCli(context)
    lang = contextUtil.getLang(context)
        
    resultDict = common.checkAluaStatus(cli, lang)
    logger.logInfo("The resultDict is %s" % resultDict)

    if not resultDict["flag"]:
        logger.logNoPass("Getting Alua statues failure")
        contextUtil.handleFailure(context, resultDict)
        return
            
    multipathTypeList = resultDict["ret"]
    logger.logInfo("Getting the multipath Type List without the name of WWN :%s" % multipathTypeList)
        
    if "ALUA" in multipathTypeList or "Third-party" in multipathTypeList:
        resultDict["flag"] = False
        resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "check.alua.status")
        contextUtil.handleFailure(context, resultDict)
        return
        
    contextUtil.handleSuccess(context)
    logger.logPass()
    return

def showWarning(context):
    lang = contextUtil.getLang(context)
    logger = common.getLogger(context.get("logger"), __file__)
    resultDict = {"flag":True, "errMsg":"", "suggestion":"", "ret":None}
    
    dialogUtil = context['dialogUtil']
    msg = common.getMsg(lang, "check.alua.status.reference.instrutor")[0]
    rec = dialogUtil.showWarningDialog(msg)
    if rec:
        contextUtil.handleSuccess(context)
        logger.logPass()
        return
                    
    resultDict["flag"] = False
    resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "check.alua.status")
    contextUtil.handleFailure(context, resultDict)
    return


def execute(context): 
    try:
        logger = common.getLogger(context.get("logger"), __file__)
        for retryTime in range(0,common.ALUA_CHECK_RETRY_TIMES):
            execute_check(context, retryTime)
            if context["succ"] != True:
                baseUtil.safeSleep(common.ALUA_CHECK_RETRY_INTERVAL)
                continue
            return
        showWarning(context)
        return
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return