# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.frame.tlv import tlvUtil

def execute(context):
    '''
    @summary: 检查IBC公私钥对是否为默认值
    '''
    
    try:
        resultDict = {"flag":True, "errMsg":"", "suggestion":""}
        logger = common.getLogger(context.get("logger"), __file__)
        
        tlv = contextUtil.getTlv(context)
        lang = contextUtil.getLang(context)
        
        #检查IBC公私钥对是否为默认值
        iBCKeyPairChanged = tlvUtil.isIBCKeyPairChanged(tlv)
        logger.logInfo("iBCKeyPairChanged:%s" % iBCKeyPairChanged)
        if iBCKeyPairChanged == 1:
            logger.logNoPass("origin controllers IBC key pair changed")
            resultDict["flag"] = False
            resultDict["errMsg"],resultDict["suggestion"] = common.getMsg(lang, "old.ctrls.ibc.keyPair.changed")
            contextUtil.handleFailure(context, resultDict)
            return
        
        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
