# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.frame.tlv import tlvUtil

def execute(context):
    '''
    @summary: 检查IBC密码是否为默认密码
    '''
    
    try:
        resultDict = {"flag":True, "errMsg":"", "suggestion":""}
        logger = common.getLogger(context.get("logger"), __file__)
        
        tlv = contextUtil.getTlv(context)
        lang = contextUtil.getLang(context)
        
        #检查IBC密码是否为默认密码
        iBCPasswordChanged = tlvUtil.isIBCPasswordChanged(tlv)
        if iBCPasswordChanged == 1:
            logger.logNoPass("origin controllers IBC password changed")
            resultDict["flag"] = False
            resultDict["errMsg"],resultDict["suggestion"] = common.getMsg(lang, "old.ctrls.ibc.pwd.changed")
            contextUtil.handleFailure(context, resultDict)
            return
        
        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
