# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.frame.tlv import adTlvUtil


def execute(context):
    '''
    @summary: judge whether exist disk domain or not use TLV protocol
    '''

    try:
        resultDict = {"flag": True, "errMsg": "", "suggestion": ""}
        logger = common.getLogger(context.get("logger"), __file__)

        lang = contextUtil.getLang(context)
        tlv = contextUtil.getTlv(context)
        newBoardsList = contextUtil.getItem(context, "newBoardsList")

        poolBoardSet = set()

        for board in newBoardsList:
            storagePool = adTlvUtil.getDiskPoolRecords(tlv, board)

            if storagePool is None or len(storagePool) == 0:
                continue
            poolBoardSet.add(board["enclosureSN"])

        logger.logInfo("poolBoardSet:%s" % poolBoardSet)

        # if exist storage pool, this check item state should be not pass
        if poolBoardSet:
            logger.logNoPass("Do not support expansion, because exist storage pool")
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "exist.diskPool.donot.support.expansion", ",".join(poolBoardSet))
            contextUtil.handleFailure(context, resultDict)
            return

        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
