# -*- coding: UTF-8 -*-
from cbb.business.operate.expansion import common
from cbb.frame.context import contextUtil
from cbb.frame.tlv import tlvUtil
from cbb.frame.tlv import tlvData
from cbb.business.operate.expansion import config

#进度总剩余时间
LIMIT_TIME = 20
#进度刷新间隔
INTERVAL = 2

def execute(context):
    '''
    @summary: 检查原集群SmartIo和接口卡端口光模块信息
    '''
    try:
        #进度条刷新
        common.threadUpProcess(context, LIMIT_TIME, INTERVAL)
        #进度开始
        common.inProcess(context)
        
        resultDict = {"flag":True, "errMsg":"", "suggestion":""}
        logger = common.getLogger(context.get("logger"), __file__)
        tlv = contextUtil.getTlv(context)
        lang = contextUtil.getLang(context)
        
        newConfigClustType = contextUtil.getItem(context, "newConfigClustType")
        ctrlHeight = contextUtil.getItem(context, "ctrlHeight")
       
        #获取原集群控制器数量
        controllerNum = tlvUtil. getControllersNum(tlv)
        if controllerNum == 0 :
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "cannot.get.controller.info")
            contextUtil.handleFailure(context, resultDict)
            return
        
        #获取所有的扩容 槽位接口卡的数量
        IntfModuleList = common.getScaleOutIntfModuleList(tlv, ctrlHeight)  
        logger.logInfo("IntfModuleList:%s" % IntfModuleList)
        IntfModuleLocationList = [] #获取扩容槽位的接口卡的位置集合
        abnormalSmartIoStatusList = []   #扩容槽位的接口卡状态不正常的位置集合
        notSmartIOLocationList = []         #扩容槽位的接口卡不为SmartIO位置的集合
        abnormalrunModeList = []
        for smartIoIntfModule in IntfModuleList:
            intfModuleLocation = smartIoIntfModule["location"]
            IntfModuleLocationList.append(intfModuleLocation)
            
            smartIoMode = smartIoIntfModule["model"]
            if smartIoMode != tlvData.INTF_MODEL_E['IOC_4XSMART']:
                notSmartIOLocationList.append(intfModuleLocation)
                continue
            
            healthStatus = smartIoIntfModule["healthStatus"]
            runningStatus = smartIoIntfModule["runningStatus"]
            if healthStatus != tlvData.HEALTH_STATUS_E['NORMAL'] or runningStatus != tlvData.RUNNING_STATUS_E['RUNNING']: 
                abnormalSmartIoStatusList.append(intfModuleLocation)
                
            runMode = smartIoIntfModule["runMode"]
            if runMode != common.INTF_RUNMODEL_CLUSTER:
                abnormalrunModeList.append(intfModuleLocation)
        
        #接口卡的数量不满足扩容条件
        if  len(IntfModuleList) != controllerNum  :  
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "interface.modules.insufficeint.old", (len(IntfModuleList), (controllerNum)))
            contextUtil.handleFailure(context, resultDict)
            return
        
        #扩容槽位的接口卡的类型不匹配
        logger.logInfo("notSmartIOLocationList:%s" % notSmartIOLocationList)
        if len(notSmartIOLocationList) != 0:
            abnormasmartIoModeStr = ','.join(notSmartIOLocationList)
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "interface.modules.insufficeint.smartio", (abnormasmartIoModeStr))
            contextUtil.handleFailure(context, resultDict)
            return

        #扩容槽位接口卡的状态不正常
        if len(abnormalSmartIoStatusList) != 0:
            abnormalSmartIoStr = ",".join(abnormalSmartIoStatusList)
            logger.logInfo("abnormalSmartIoStr:%s" % abnormalSmartIoStr)
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "smartio.interface.modules.status.abnormal",
               (abnormalSmartIoStr))
            contextUtil.handleFailure(context, resultDict)
            return
        
        #获取所有接口模块所有的光模块
        records = tlvUtil.getSfpOpticalTransceiver(tlv)
        logger.logInfo("firbeModulerecords:%s" % records)
        fiberModulelocationList = [] #IP scale_out接口卡上光模块位置集合
        SpeedAbnormalfiberModulelocationList = []
        for record in records:
            SfpOpticalTransceiverlocation = tlvUtil.getRecordValue(record, tlvData.PUB_ATTR['location'])
            if SfpOpticalTransceiverlocation[:-3]  not in IntfModuleLocationList:
                continue
            fiberModulelocationList.append(SfpOpticalTransceiverlocation)
            speed = tlvUtil.getRecordValue(record, tlvData.SFP_OPTICAL_TRANSCEIVER['speed'])
            if speed != config.SPEED:
                SpeedAbnormalfiberModulelocationList.append(SfpOpticalTransceiverlocation)
        
        #SmartIO接口卡上的光模块的数量不满足扩容条件       
        logger.logInfo("The location list of fiber model using for Expansion is :%s" % len(fiberModulelocationList))
        if (newConfigClustType == common.CLUST_TYPE_DIRECT and \
                len(fiberModulelocationList) != len(IntfModuleLocationList) * 4):
            NeedFiberLocationList=[]
            for smartIoLocation in IntfModuleLocationList:
                NeedFiberLocationList += getFiberLoaction(smartIoLocation, newConfigClustType)
            logger.logInfo(" fiberModulelocationList:%s" % fiberModulelocationList)
            #求差集
            differenceList = list(set(NeedFiberLocationList).difference(set(fiberModulelocationList)))
            if len(differenceList) != 0:
                resultDict["flag"] = False
                resultDict["errMsg"] , resultDict["suggestion"] = common.getMsg(lang, "fibermodule.number.inconsistent", suggestionArgs=','.join(differenceList))
                contextUtil.handleFailure(context, resultDict)
                return  
        
        if (newConfigClustType == common.CLUST_TYPE_SWITCH and \
                len(fiberModulelocationList) != len(IntfModuleLocationList) * 2):
            NeedFiberLocationList=[]
            for smartIoLocation in IntfModuleLocationList:
                NeedFiberLocationList += getFiberLoaction(smartIoLocation, newConfigClustType)
               
            logger.logInfo("NeedFirbeLocationList:%s" % NeedFiberLocationList)
            differenceList = list(set(NeedFiberLocationList).difference(set(fiberModulelocationList)))
            if len(differenceList) != 0:
                resultDict["flag"] = False
                resultDict["errMsg"] , resultDict["suggestion"] = common.getMsg(lang, "fibermodule.number.inconsistent", suggestionArgs=(','.join(differenceList)))
                contextUtil.handleFailure(context, resultDict)
                return  
        
        #SmartIO接口卡上的光模块的速率不满足扩容条件    
        logger.logInfo("SpeedAbnormalfiberModulelocationList:%s" % SpeedAbnormalfiberModulelocationList)
        if len(SpeedAbnormalfiberModulelocationList) != 0:
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "smartio.fibermodule.rate.abnormal", (','.join(SpeedAbnormalfiberModulelocationList)))
            contextUtil.handleFailure(context, resultDict)
            return
            
        #检查工作模式是否为Cluster，原集群必须为集群模式，待扩容控制器必须为集群模式或以太模式
        if len(abnormalrunModeList) != 0:
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "smartio.interface.modules.runmode.error.old", (','.join(abnormalrunModeList)))
            contextUtil.handleFailure(context, resultDict)
            return
                                 
        contextUtil.handleSuccess(context)
        logger.logPass()
        return
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return      
    finally:
        #进度条刷为完成状态
        common.finishProcess(context)      
     
def getFiberLoaction(inftLocation, newConfigClustType):
    '''
    @summary: 获取标准SmartIO接口模块需要光模块的所有位置
    @param inftLocation: SmartIO接口卡的location
    @param newConfigClustType: 组网类型
    @return: 以列表形式返回结果 
       
    '''
    loctionList = []
    P0 = inftLocation + '.P0'
    P1 = inftLocation + '.P1'
    loctionList.append(P0)
    loctionList.append(P1)
    if newConfigClustType == common.CLUST_TYPE_DIRECT:
        P2 = inftLocation + '.P2'
        P3 = inftLocation + '.P3'
        loctionList.append(P2)
        loctionList.append(P3)
    return loctionList
