# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common

def execute(context):
    '''
    @summary: 检查设备上是否存在特定告警
    '''

    try:
        logger = common.getLogger(context.get("logger"), __file__)
        common.setExpSucNotice(context)
        cli = contextUtil.getCli(context)
        lang = contextUtil.getLang(context)

        #检查设备上是否存在特定告警
        checkAlarmRetDict = common.checkSysAlarm(cli, lang, common.POST_CHECK_ALARM_WHITELIST)
        if not checkAlarmRetDict["flag"]:
            logger.logNoPass("System exists major or critical alarms")
            contextUtil.handleFailure(context, checkAlarmRetDict)
            return
        
        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
    finally:
        context["remindInfo"] = ""
