# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.frame.tlv import tlvUtil
from cbb.frame.tlv import tlvData

def execute(context):
    '''
    @summary: 系统异常复位后台任务抑制检查
    '''
    try:
        resultDict = {"flag":True, "errMsg":"", "suggestion":""}
        logger = common.getLogger(context.get("logger"), __file__)
        
        tlv = contextUtil.getTlv(context)
        lang = contextUtil.getLang(context)
        
        if checkValidVersion(context, logger):
            recs = tlvUtil.getCtrlTaskRestrictState(tlv)
            logger.logInfo("records=%s" % unicode(recs))
            for record in recs:
                state = tlvUtil.getRecordValue(record, tlvData.RESTROCTST_TASK["RESTROCTST_STATE"])
                if state:
                    logger.logNoPass("System Background Tasks Are Suppressed")
                    resultDict["flag"] = False
                    resultDict["errMsg"],resultDict["suggestion"] = common.getMsg(lang, "precheck.restrictstate.suppressed")
                    contextUtil.handleFailure(context, resultDict)
                    return
            contextUtil.handleSuccess(context)
            logger.logPass()
            return
        #非有效版本，直接通过，不阻塞流程
        else:
            contextUtil.handleSuccess(context)

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return

def checkValidVersion(context, logger):
    #Dorado 版本扩控制器（从C21开始，C21TR5版本不涉及，TR6及后续版本开始限制）
    #V5R7C10/V3R6C20（含）以后的都支持
    productVersion = contextUtil.getItem(context, "fullProductVersion")  
    logger.logInfo("CheckRestrictTask productVersion:%s" % productVersion)
    productModel = contextUtil.getItem(context, "productModel") 
    logger.logInfo("CheckRestrictTask productModel:%s" % productModel)
    if "DORADO" in productModel.upper() and productVersion > 'V300R001C21':
        return True
    if "V500R007" in productVersion.upper() and productVersion >= 'V500R007C10':
        return True
    if "V300R006" in productVersion.upper() and productVersion >= 'V300R006C20':
        return True
    return False
