# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import config
from cbb.frame.tlv import tlvUtil


def execute(context):
    '''
    @summary: 检查SES版本一致性
    '''
    
    try:
        logger = common.getLogger(context.get("logger"), __file__)
        common.setExpSucNotice(context)
        tlv = contextUtil.getTlv(context)
        
        #扩容前硬盘框数量
        diskEncNum = contextUtil.getItem(context, "diskEnclosureNum")  
        
        #扩容后硬盘框数量
        enclosureRecords = tlvUtil.getEnclosureRecords(tlv)
        currdiskEncNum = len(tlvUtil.getDiskEnclouresName(enclosureRecords))
        logger.logInfo("current disk enclosure number:%s, before expansion number:%s" %(currdiskEncNum, diskEncNum))
        totalReaminTime = config.PER_CHECK_FW_TIME * (abs(currdiskEncNum - diskEncNum) + 1)
 
        #剩余时间总数
        contextUtil.setItem(context, "totalReaminTime", totalReaminTime)
        context["curRemainTime"] = totalReaminTime
        common.setExpansionProgress(context, True)
               
        #检查SES、CPLD版本一致性
        checkExpModuleSESVersionsRetDict = common.checkExpModuleSESVersions(context, totalReaminTime)
        
        if not checkExpModuleSESVersionsRetDict["flag"]:
            logger.logNoPass("check SES versions failure")
            contextUtil.handleFailure(context, checkExpModuleSESVersionsRetDict)
            return
        
        contextUtil.handleSuccess(context)
        logger.logPass()
        return
        
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
    finally:
        context["curRemainTime"] = 0
        common.setExpansionProgress(context, True)
        context["remindInfo"] = ""
