# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.frame.tlv import tlvUtil

SINGLE_CTRL = "SINGLE_CTRL"

def execute(context):
    '''
    @summary: 检查系统模式为单控模式
    '''
    
    try:
        resultDict = {"flag":True, "errMsg":"", "suggestion":""}
        logger = common.getLogger(context.get("logger"), __file__)
        
        tlv = contextUtil.getTlv(context)
        lang = contextUtil.getLang(context)
        
        #检查系统模式为单控模式
        sysConfigModel = tlvUtil.getSysConfigModel(tlv)
        
        if sysConfigModel != SINGLE_CTRL:
            logger.logNoPass("The System is not in single-controller model.")
            resultDict["flag"] = False
            resultDict["errMsg"],resultDict["suggestion"] = common.getMsg(lang, "system.is.not.in.single.controller.model")
            contextUtil.handleFailure(context, resultDict)
            return

        contextUtil.setSingleCtrl(context)
        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
