# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common

def execute(context):
    '''
    @summary: 检查系统状态健康状态和运行状态是否正常
    '''

    try:
        logger = common.getLogger(context.get("logger"), __file__)
        
        cli = contextUtil.getCli(context)
        lang = contextUtil.getLang(context)
        
        #检查系统状态健康状态和运行状态是否正常
        checkSystemStatusRetDict = common.checkSystemStatus(cli, lang)
        if not checkSystemStatusRetDict["flag"]:
            logger.logNoPass("System status is abnormal")
            contextUtil.handleFailure(context, checkSystemStatusRetDict)
            return
        
        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
