# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common

def execute(context):
    '''
    @summary: 检查用户权限为超级管理员
    '''
    
    try:
        logger = common.getLogger(context.get("logger"), __file__)
        
        cli = contextUtil.getCli(context)
        lang = contextUtil.getLang(context)
        
        #检查用户权限为管理员或超级管理员
        checkPrevilegeRetDict = common.checkSuperAdminPrevilege(cli, lang)
        if not checkPrevilegeRetDict["flag"]:
            logger.logNoPass("User is not Admin User or Super Admin User")
            contextUtil.handleFailure(context, checkPrevilegeRetDict)
            return
        
        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
