# -*- coding: UTF-8 -*-
from cbb.business.operate.expansion import common
from cbb.frame.context import contextUtil
from cbb.frame.cli import cliUtil


def execute(context):
    """
    备份引擎检查
    :param context:
    :return:
    """
    cli = contextUtil.getCli(context)
    lang = contextUtil.getLang(context)
    logger = common.getLogger(context.get("logger"), __file__)

    try:
        cmd = "show container_application general"
        flag, cli_ret, err_msg = \
            cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        logger.logInfo("cli_ret = {}".format(str(cli_ret)))

        if flag is not True:
            err_msg, suggestion = common.getMsg(lang, "system.abnormal")
            contextUtil.handleFailure(
                context,
                {"flag": False, "errMsg": err_msg, "suggestion": suggestion})
            return
        if "dataprotect" in cli_ret:
            contextUtil.handleSuccess(context)
            return

        err_msg, suggestion = common.getMsg(lang, "not.install.backup.engine")
        contextUtil.handleFailure(
            context,
            {"flag": False, "errMsg": err_msg, "suggestion": suggestion})
        return
    except Exception as e:
        contextUtil.handleException(context, e)
        return
